/*
 * Decompiled with CFR 0.152.
 */
package no.nav.fasit;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;
import no.nav.apiapp.util.ObjectUtils;
import no.nav.fasit.ApplicationConfig;
import no.nav.fasit.DbCredentials;
import no.nav.fasit.LdapConfig;
import no.nav.fasit.LoadBalancerConfig;
import no.nav.fasit.OpenAmConfig;
import no.nav.fasit.Queue;
import no.nav.fasit.QueueManager;
import no.nav.fasit.Scoped;
import no.nav.fasit.ServiceUser;
import no.nav.fasit.ServiceUserCertificate;
import no.nav.fasit.TestEnvironment;
import no.nav.fasit.TestUser;
import no.nav.fasit.Util;
import no.nav.fasit.WebServiceEndpoint;
import no.nav.fasit.client.FasitClient;
import no.nav.fasit.client.FasitClientImpl;
import no.nav.fasit.client.FasitClientMock;
import no.nav.fasit.dto.RestService;
import no.nav.sbl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FasitUtils {
    public static final String FASIT_USERNAME_VARIABLE_NAME = "domenebrukernavn";
    public static final String FASIT_PASSWORD_VARIABLE_NAME = "domenepassord";
    public static final String DEFAULT_ENVIRONMENT_VARIABLE_NAME = "testmiljo";
    public static final String MOCK_VARIABLE_NAME = "mock";
    private static final String MOCK_ENVIRONMENT_VARIABLE = "FASIT_MOCK_ENABLED";
    private static final File fasitPropertyFile = new File(System.getProperty("user.home"), "fasit.properties");
    private static final Logger LOG = LoggerFactory.getLogger(FasitUtils.class);
    public static final String WELL_KNOWN_APPLICATION_NAME = "fasit";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public static final String TEST_LOCAL = "test.local";
    public static final String OERA_T_LOCAL = "oera-t.local";
    public static final String OERA_Q_LOCAL = "oera-q.local";
    public static final String PREPROD_LOCAL = "preprod.local";
    private static final Map<String, List<String>> domainsByEnvironmentClass = new HashMap<String, List<String>>();
    private static final Map<String, Zone> zoneByDomain = new HashMap<String, Zone>();
    private static final List<String> T_DOMAINS = Arrays.asList("oera-t.local", "test.local");
    private static final List<String> Q_DOMAINS = Arrays.asList("oera-q.local", "preprod.local");
    public static final String TEST_DATA_ALIAS = "test_data";

    public static String getVariable(String variableName) {
        return Optional.ofNullable(System.getProperty(variableName, System.getenv(variableName))).orElseGet(() -> FasitUtils.getVariableFromPropertyFile(variableName));
    }

    private static String getVariableFromPropertyFile(String variableName) {
        if (FasitUtils.usingMock()) {
            return variableName;
        }
        return FasitUtils.getOptionalVariableFromPropertyFile(variableName).orElseThrow(() -> new IllegalStateException(String.format("mangler variabel '%s'. \nDenne m\u00e5 settes som property, milj\u00f8variabel eller i '%s'.\nEvt set variabelen %s=true for \u00e5 bruke mock-verdier\n", variableName, fasitPropertyFile.getAbsolutePath(), MOCK_VARIABLE_NAME)));
    }

    private static Optional<String> getOptionalVariableFromPropertyFile(String variableName) {
        return Optional.of(fasitPropertyFile).filter(File::exists).map(Util::loadProperties).map(fasitProperties -> fasitProperties.getProperty(variableName));
    }

    public static DbCredentials getDbCredentials(String applicationName) {
        return FasitUtils.getDbCredentials(FasitUtils.getDefaultTestEnvironment(), applicationName);
    }

    public static DbCredentials getDbCredentials(TestEnvironment testEnvironment, String applicationName) {
        return FasitUtils.getFasitClient().getDbCredentials(FasitClient.GetDbCredentialsRequest.builder().testEnvironment(testEnvironment).applicationName(applicationName).build());
    }

    public static ServiceUserCertificate getServiceUserCertificate(String serviceUser, String environmentClass) {
        return FasitUtils.getFasitClient().getCertificate(FasitClient.GetCertificateRequest.builder().alias(serviceUser).environmentClass(environmentClass).build());
    }

    public static ApplicationConfig getApplicationConfig(String applicationName, String environment) {
        return FasitUtils.getFasitClient().getApplicationConfig(FasitClient.GetApplicationConfigRequest.builder().applicationName(applicationName).environment(environment).build());
    }

    public static TestUser getTestUser(String userAlias) {
        return FasitUtils.getTestUser(userAlias, FasitUtils.getDefaultEnvironment());
    }

    public static TestUser getTestUser(String userAlias, String environment) {
        ServiceUser serviceUser = FasitUtils.getServiceUser(userAlias, WELL_KNOWN_APPLICATION_NAME, environment, TEST_LOCAL);
        return new TestUser().setUsername(serviceUser.username).setPassword(serviceUser.password);
    }

    public static String getBaseUrl(String baseUrlAlias) {
        return FasitUtils.getBaseUrl(baseUrlAlias, FasitUtils.getDefaultEnvironment());
    }

    public static String getBaseUrl(String baseUrlAlias, Zone zone) {
        return FasitUtils.getBaseUrl(baseUrlAlias, FasitUtils.getDefaultEnvironment(), FasitUtils.getDefaultDomain(zone));
    }

    public static String getBaseUrl(String baseUrlAlias, String environment) {
        return FasitUtils.getBaseUrl(baseUrlAlias, environment, FasitUtils.getOeraLocal(environment));
    }

    public static String getBaseUrl(String baseUrlAlias, String environment, String domain) {
        return FasitUtils.getBaseUrl(baseUrlAlias, environment, domain, WELL_KNOWN_APPLICATION_NAME);
    }

    public static String getBaseUrl(String baseUrlAlias, String environment, String domain, String application) {
        return FasitUtils.getFasitClient().getBaseUrl(FasitClient.GetBaseUrlRequest.builder().baseUrlAlias(baseUrlAlias).environment(environment).domain(domain).application(application).build());
    }

    public static List<LoadBalancerConfig> getLoadbalancerConfig(String alias) {
        return FasitUtils.getFasitClient().getLoadbalancerConfig(alias);
    }

    public static LoadBalancerConfig getLoadbalancerConfig(String alias, String environment) {
        return FasitUtils.getLoadbalancerConfig(alias).stream().filter(c -> environment.equals(c.environment)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("fant ikke '%s' i environment '%s'", alias, environment)));
    }

    public static LdapConfig getLdapConfig() {
        return FasitUtils.getLdapConfig(FasitUtils.getDefaultEnvironmentClass());
    }

    public static LdapConfig getLdapConfig(String environmentClass) {
        return FasitUtils.getFasitClient().getLdapConfig(environmentClass);
    }

    private static FasitClient getFasitClient() {
        return FasitUtils.usingMock() ? new FasitClientMock() : new FasitClientImpl();
    }

    public static boolean usingMock() {
        return FasitUtils.getOptionalVariableFromPropertyFile(MOCK_VARIABLE_NAME).map(Boolean::parseBoolean).orElse(Boolean.parseBoolean(System.getenv(MOCK_ENVIRONMENT_VARIABLE)));
    }

    public static List<RestService> getRestServices(String alias) {
        return FasitUtils.getFasitClient().getRestServices(alias);
    }

    public static RestService getRestService(String alias) {
        return FasitUtils.bestMatch(FasitUtils.getRestServices(alias));
    }

    public static RestService getRestService(String alias, String environment) {
        return FasitUtils.getRestServices(alias).stream().filter(r -> ObjectUtils.isEqual((Object)r.getEnvironment(), (Object)environment)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("did not find %s in %s", alias, environment)));
    }

    public static WebServiceEndpoint getWebServiceEndpoint(String alias) {
        return FasitUtils.getWebServiceEndpoint(alias, FasitUtils.getDefaultEnvironment());
    }

    public static WebServiceEndpoint getWebServiceEndpoint(String alias, String environment) {
        return FasitUtils.getFasitClient().getWebServiceEndpoint(alias, environment);
    }

    public static ServiceUser getServiceUser(String userAlias, String applicationName) {
        return FasitUtils.getServiceUser(userAlias, applicationName, FasitUtils.getDefaultEnvironment());
    }

    public static ServiceUser getServiceUser(String userAlias, String applicationName, TestEnvironment environment) {
        return FasitUtils.getServiceUser(userAlias, applicationName, environment.toString());
    }

    public static ServiceUser getServiceUser(String userAlias, String applicationName, Zone zone) {
        String defaultEnvironment = FasitUtils.getDefaultEnvironment();
        return FasitUtils.getServiceUser(userAlias, applicationName, defaultEnvironment, zone.getDomain(defaultEnvironment));
    }

    public static ServiceUser getServiceUser(String userAlias, String applicationName, String environment) {
        return FasitUtils.getServiceUser(userAlias, applicationName, environment, FasitUtils.resolveDomain(applicationName, environment));
    }

    static String resolveDomain(String applicationName, String environment) {
        if (FasitUtils.usingMock()) {
            return MOCK_VARIABLE_NAME;
        }
        ApplicationConfig applicationConfig = FasitUtils.getApplicationConfig(applicationName, environment);
        String domain = applicationConfig.domain;
        List<String> domains = FasitUtils.getDomains(environment);
        if (domains.contains(domain)) {
            return domain;
        }
        Zone zone = zoneByDomain.get(domain);
        return zone.getDomain(environment);
    }

    public static String getDefaultDomain(Zone zone) {
        return zone.getDomain(FasitUtils.getDefaultEnvironment());
    }

    private static List<String> getDomains(String environment) {
        return domainsByEnvironmentClass.get(FasitUtils.getEnvironmentClass(environment));
    }

    public static OpenAmConfig getOpenAmConfig() {
        return FasitUtils.getOpenAmConfig(FasitUtils.getDefaultEnvironment());
    }

    public static OpenAmConfig getOpenAmConfig(String environment) {
        OpenAmConfig openAmConfig = FasitUtils.getFasitClient().getOpenAmConfig(environment);
        LOG.info("openAm: {}", (Object)openAmConfig);
        return openAmConfig;
    }

    public static ServiceUser getServiceUser(String userAlias, String applicationName, String environment, String domain) {
        return FasitUtils.getFasitClient().getCredentials(FasitClient.GetCredentialsRequest.builder().userAlias(userAlias).applicationName(applicationName).environment(environment).domain(domain).build());
    }

    public static Optional<String> getTestDataProperty(String propertyName) {
        return Optional.ofNullable(FasitUtils.getTestDataProperties().getProperty(propertyName)).filter(StringUtils::notNullOrEmpty);
    }

    public static Properties getTestDataProperties() {
        return FasitUtils.getApplicationProperties(TEST_DATA_ALIAS);
    }

    public static Properties getApplicationProperties(String alias) {
        return FasitUtils.bestMatch(FasitUtils.getFasitClient().getApplicationProperties(FasitClient.GetApplicationPropertiesRequest.builder().alias(alias).environmentClass(FasitUtils.getDefaultEnvironmentClass()).build()));
    }

    public static String getFasitPassword() {
        return FasitUtils.getVariable(FASIT_PASSWORD_VARIABLE_NAME);
    }

    public static String getFasitUser() {
        return FasitUtils.getVariable(FASIT_USERNAME_VARIABLE_NAME);
    }

    public static String getDefaultEnvironment() {
        return FasitUtils.getVariable(DEFAULT_ENVIRONMENT_VARIABLE_NAME);
    }

    public static String getDefaultEnvironmentClass() {
        return FasitUtils.getEnvironmentClass(FasitUtils.getDefaultEnvironment());
    }

    public static TestEnvironment getDefaultTestEnvironment() {
        return FasitUtils.usingMock() ? TestEnvironment.MOCK : TestEnvironment.valueOf(FasitUtils.getDefaultEnvironment().toUpperCase());
    }

    public static String getEnvironmentClass(String environment) {
        return environment == null ? null : environment.substring(0, 1);
    }

    public static String getOeraLocal(String environment) {
        return "oera-" + FasitUtils.getEnvironmentClass(environment) + ".local";
    }

    public static String getFSSLocal(String environment) {
        return FasitUtils.getFSSClass(environment) + ".local";
    }

    private static String getFSSClass(String environment) {
        switch (FasitUtils.getEnvironmentClass(environment)) {
            case "t": {
                return "test";
            }
            case "q": {
                return "preprod";
            }
            case "m": {
                return MOCK_VARIABLE_NAME;
            }
        }
        throw new IllegalStateException(environment);
    }

    public static Queue getQueue(String alias) {
        return FasitUtils.bestMatch(FasitUtils.getQueues(alias));
    }

    public static List<Queue> getQueues(String alias) {
        return FasitUtils.getQueues(FasitClient.GetQueueRequest.builder().alias(alias).environment(FasitUtils.getDefaultEnvironment()).build());
    }

    public static List<Queue> getQueues(FasitClient.GetQueueRequest getQueueRequest) {
        return FasitUtils.getFasitClient().getQueue(getQueueRequest);
    }

    public static QueueManager getQueueManager(String alias) {
        return FasitUtils.bestMatch(FasitUtils.getQueueManagers(alias));
    }

    private static <T extends Scoped> T bestMatch(List<T> scoped) {
        String environment = FasitUtils.getDefaultEnvironment();
        String environmentClass = FasitUtils.getEnvironmentClass(environment);
        Stream<Predicate> matchers = Stream.of(s -> ObjectUtils.isEqual((Object)environment, (Object)s.getEnvironment()), s -> ObjectUtils.isEqual((Object)environmentClass, (Object)s.getEnvironmentClass()));
        return (T)((Scoped)matchers.flatMap(p -> scoped.stream().filter(p)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("no best match for environment=%s or environmentClass=%s among: %s", environment, environmentClass, scoped))));
    }

    public static List<QueueManager> getQueueManagers(String alias) {
        return FasitUtils.getQueueManagers(FasitClient.GetQueueManagerRequest.builder().alias(alias).environmentClass(FasitUtils.getDefaultEnvironmentClass()).zone("fss").build());
    }

    public static List<QueueManager> getQueueManagers(FasitClient.GetQueueManagerRequest getQueueManagerRequest) {
        return FasitUtils.getFasitClient().getQueueManager(getQueueManagerRequest);
    }

    public static boolean erEksterntDomene(String domain) {
        return domain != null && domain.contains("oera");
    }

    public static Properties getApplicationEnvironment(String applicationName) {
        return FasitUtils.getApplicationEnvironment(applicationName, FasitUtils.getDefaultEnvironment());
    }

    public static Properties getApplicationEnvironment(String applicationName, String environment) {
        return FasitUtils.getFasitClient().getApplicationEnvironment(FasitClient.GetApplicationEnvironmentRequest.builder().applicationName(applicationName).environment(environment).build());
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        domainsByEnvironmentClass.put("t", T_DOMAINS);
        domainsByEnvironmentClass.put("q", Q_DOMAINS);
        zoneByDomain.put(OERA_Q_LOCAL, Zone.SBS);
        zoneByDomain.put(OERA_T_LOCAL, Zone.SBS);
        zoneByDomain.put(PREPROD_LOCAL, Zone.FSS);
        zoneByDomain.put(TEST_LOCAL, Zone.FSS);
    }

    public static class UsernameAndPassword {
        public String username;
        public String password;

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public UsernameAndPassword setUsername(String username) {
            this.username = username;
            return this;
        }

        public UsernameAndPassword setPassword(String password) {
            this.password = password;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsernameAndPassword)) {
                return false;
            }
            UsernameAndPassword other = (UsernameAndPassword)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UsernameAndPassword;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "FasitUtils.UsernameAndPassword(username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }

    public static enum Zone {
        FSS,
        SBS;


        public String getDomain(String environment) {
            switch (this) {
                case FSS: {
                    return FasitUtils.getFSSLocal(environment);
                }
                case SBS: {
                    return FasitUtils.getOeraLocal(environment);
                }
            }
            throw new IllegalStateException(environment);
        }
    }
}

