/*
 * Decompiled with CFR 0.152.
 */
package no.nav.fasit.client;

import java.util.List;
import java.util.Properties;
import no.nav.fasit.ApplicationConfig;
import no.nav.fasit.ApplicationProperties;
import no.nav.fasit.AzureOidcConfig;
import no.nav.fasit.DbCredentials;
import no.nav.fasit.FasitUtils;
import no.nav.fasit.LdapConfig;
import no.nav.fasit.LoadBalancerConfig;
import no.nav.fasit.OpenAmConfig;
import no.nav.fasit.Queue;
import no.nav.fasit.QueueManager;
import no.nav.fasit.ServiceUser;
import no.nav.fasit.ServiceUserCertificate;
import no.nav.fasit.TestEnvironment;
import no.nav.fasit.WebServiceEndpoint;
import no.nav.fasit.dto.RestService;

public interface FasitClient {
    public String getBaseUrl(GetBaseUrlRequest var1);

    public OpenAmConfig getOpenAmConfig(String var1);

    public AzureOidcConfig getAzureOidcConfig(String var1, String var2, FasitUtils.Zone var3);

    public List<RestService> getRestServices(String var1);

    public WebServiceEndpoint getWebServiceEndpoint(String var1, String var2);

    public List<LoadBalancerConfig> getLoadbalancerConfig(String var1);

    public DbCredentials getDbCredentials(GetDbCredentialsRequest var1);

    public ServiceUserCertificate getCertificate(GetCertificateRequest var1);

    public ServiceUser getCredentials(GetCredentialsRequest var1);

    public ApplicationConfig getApplicationConfig(GetApplicationConfigRequest var1);

    public Properties getApplicationEnvironment(GetApplicationEnvironmentRequest var1);

    public List<ApplicationProperties> getApplicationProperties(GetApplicationPropertiesRequest var1);

    public LdapConfig getLdapConfig(String var1);

    public List<Queue> getQueue(GetQueueRequest var1);

    public List<QueueManager> getQueueManager(GetQueueManagerRequest var1);

    public static final class GetQueueManagerRequest {
        public final String alias;
        public final String environmentClass;
        public final String zone;

        GetQueueManagerRequest(String alias, String environmentClass, String zone) {
            this.alias = alias;
            this.environmentClass = environmentClass;
            this.zone = zone;
        }

        public static GetQueueManagerRequestBuilder builder() {
            return new GetQueueManagerRequestBuilder();
        }

        public String getAlias() {
            return this.alias;
        }

        public String getEnvironmentClass() {
            return this.environmentClass;
        }

        public String getZone() {
            return this.zone;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetQueueManagerRequest)) {
                return false;
            }
            GetQueueManagerRequest other = (GetQueueManagerRequest)o;
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            String this$environmentClass = this.getEnvironmentClass();
            String other$environmentClass = other.getEnvironmentClass();
            if (this$environmentClass == null ? other$environmentClass != null : !this$environmentClass.equals(other$environmentClass)) {
                return false;
            }
            String this$zone = this.getZone();
            String other$zone = other.getZone();
            return !(this$zone == null ? other$zone != null : !this$zone.equals(other$zone));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            String $environmentClass = this.getEnvironmentClass();
            result = result * 59 + ($environmentClass == null ? 43 : $environmentClass.hashCode());
            String $zone = this.getZone();
            result = result * 59 + ($zone == null ? 43 : $zone.hashCode());
            return result;
        }

        public String toString() {
            return "FasitClient.GetQueueManagerRequest(alias=" + this.getAlias() + ", environmentClass=" + this.getEnvironmentClass() + ", zone=" + this.getZone() + ")";
        }

        public static class GetQueueManagerRequestBuilder {
            private String alias;
            private String environmentClass;
            private String zone;

            GetQueueManagerRequestBuilder() {
            }

            public GetQueueManagerRequestBuilder alias(String alias) {
                this.alias = alias;
                return this;
            }

            public GetQueueManagerRequestBuilder environmentClass(String environmentClass) {
                this.environmentClass = environmentClass;
                return this;
            }

            public GetQueueManagerRequestBuilder zone(String zone) {
                this.zone = zone;
                return this;
            }

            public GetQueueManagerRequest build() {
                return new GetQueueManagerRequest(this.alias, this.environmentClass, this.zone);
            }

            public String toString() {
                return "FasitClient.GetQueueManagerRequest.GetQueueManagerRequestBuilder(alias=" + this.alias + ", environmentClass=" + this.environmentClass + ", zone=" + this.zone + ")";
            }
        }
    }

    public static final class GetQueueRequest {
        public final String alias;
        public final String environment;

        GetQueueRequest(String alias, String environment) {
            this.alias = alias;
            this.environment = environment;
        }

        public static GetQueueRequestBuilder builder() {
            return new GetQueueRequestBuilder();
        }

        public String getAlias() {
            return this.alias;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetQueueRequest)) {
                return false;
            }
            GetQueueRequest other = (GetQueueRequest)o;
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            String this$environment = this.getEnvironment();
            String other$environment = other.getEnvironment();
            return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            String $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            return result;
        }

        public String toString() {
            return "FasitClient.GetQueueRequest(alias=" + this.getAlias() + ", environment=" + this.getEnvironment() + ")";
        }

        public static class GetQueueRequestBuilder {
            private String alias;
            private String environment;

            GetQueueRequestBuilder() {
            }

            public GetQueueRequestBuilder alias(String alias) {
                this.alias = alias;
                return this;
            }

            public GetQueueRequestBuilder environment(String environment) {
                this.environment = environment;
                return this;
            }

            public GetQueueRequest build() {
                return new GetQueueRequest(this.alias, this.environment);
            }

            public String toString() {
                return "FasitClient.GetQueueRequest.GetQueueRequestBuilder(alias=" + this.alias + ", environment=" + this.environment + ")";
            }
        }
    }

    public static final class GetApplicationPropertiesRequest {
        public final String alias;
        public final String environmentClass;

        GetApplicationPropertiesRequest(String alias, String environmentClass) {
            this.alias = alias;
            this.environmentClass = environmentClass;
        }

        public static GetApplicationPropertiesRequestBuilder builder() {
            return new GetApplicationPropertiesRequestBuilder();
        }

        public String getAlias() {
            return this.alias;
        }

        public String getEnvironmentClass() {
            return this.environmentClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetApplicationPropertiesRequest)) {
                return false;
            }
            GetApplicationPropertiesRequest other = (GetApplicationPropertiesRequest)o;
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            String this$environmentClass = this.getEnvironmentClass();
            String other$environmentClass = other.getEnvironmentClass();
            return !(this$environmentClass == null ? other$environmentClass != null : !this$environmentClass.equals(other$environmentClass));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            String $environmentClass = this.getEnvironmentClass();
            result = result * 59 + ($environmentClass == null ? 43 : $environmentClass.hashCode());
            return result;
        }

        public String toString() {
            return "FasitClient.GetApplicationPropertiesRequest(alias=" + this.getAlias() + ", environmentClass=" + this.getEnvironmentClass() + ")";
        }

        public static class GetApplicationPropertiesRequestBuilder {
            private String alias;
            private String environmentClass;

            GetApplicationPropertiesRequestBuilder() {
            }

            public GetApplicationPropertiesRequestBuilder alias(String alias) {
                this.alias = alias;
                return this;
            }

            public GetApplicationPropertiesRequestBuilder environmentClass(String environmentClass) {
                this.environmentClass = environmentClass;
                return this;
            }

            public GetApplicationPropertiesRequest build() {
                return new GetApplicationPropertiesRequest(this.alias, this.environmentClass);
            }

            public String toString() {
                return "FasitClient.GetApplicationPropertiesRequest.GetApplicationPropertiesRequestBuilder(alias=" + this.alias + ", environmentClass=" + this.environmentClass + ")";
            }
        }
    }

    public static final class GetApplicationEnvironmentRequest {
        public final String applicationName;
        public final String environment;

        GetApplicationEnvironmentRequest(String applicationName, String environment) {
            this.applicationName = applicationName;
            this.environment = environment;
        }

        public static GetApplicationEnvironmentRequestBuilder builder() {
            return new GetApplicationEnvironmentRequestBuilder();
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetApplicationEnvironmentRequest)) {
                return false;
            }
            GetApplicationEnvironmentRequest other = (GetApplicationEnvironmentRequest)o;
            String this$applicationName = this.getApplicationName();
            String other$applicationName = other.getApplicationName();
            if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
                return false;
            }
            String this$environment = this.getEnvironment();
            String other$environment = other.getEnvironment();
            return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $applicationName = this.getApplicationName();
            result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
            String $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            return result;
        }

        public String toString() {
            return "FasitClient.GetApplicationEnvironmentRequest(applicationName=" + this.getApplicationName() + ", environment=" + this.getEnvironment() + ")";
        }

        public static class GetApplicationEnvironmentRequestBuilder {
            private String applicationName;
            private String environment;

            GetApplicationEnvironmentRequestBuilder() {
            }

            public GetApplicationEnvironmentRequestBuilder applicationName(String applicationName) {
                this.applicationName = applicationName;
                return this;
            }

            public GetApplicationEnvironmentRequestBuilder environment(String environment) {
                this.environment = environment;
                return this;
            }

            public GetApplicationEnvironmentRequest build() {
                return new GetApplicationEnvironmentRequest(this.applicationName, this.environment);
            }

            public String toString() {
                return "FasitClient.GetApplicationEnvironmentRequest.GetApplicationEnvironmentRequestBuilder(applicationName=" + this.applicationName + ", environment=" + this.environment + ")";
            }
        }
    }

    public static final class GetApplicationConfigRequest {
        public final String applicationName;
        public final String environment;

        GetApplicationConfigRequest(String applicationName, String environment) {
            this.applicationName = applicationName;
            this.environment = environment;
        }

        public static GetApplicationConfigRequestBuilder builder() {
            return new GetApplicationConfigRequestBuilder();
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetApplicationConfigRequest)) {
                return false;
            }
            GetApplicationConfigRequest other = (GetApplicationConfigRequest)o;
            String this$applicationName = this.getApplicationName();
            String other$applicationName = other.getApplicationName();
            if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
                return false;
            }
            String this$environment = this.getEnvironment();
            String other$environment = other.getEnvironment();
            return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $applicationName = this.getApplicationName();
            result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
            String $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            return result;
        }

        public String toString() {
            return "FasitClient.GetApplicationConfigRequest(applicationName=" + this.getApplicationName() + ", environment=" + this.getEnvironment() + ")";
        }

        public static class GetApplicationConfigRequestBuilder {
            private String applicationName;
            private String environment;

            GetApplicationConfigRequestBuilder() {
            }

            public GetApplicationConfigRequestBuilder applicationName(String applicationName) {
                this.applicationName = applicationName;
                return this;
            }

            public GetApplicationConfigRequestBuilder environment(String environment) {
                this.environment = environment;
                return this;
            }

            public GetApplicationConfigRequest build() {
                return new GetApplicationConfigRequest(this.applicationName, this.environment);
            }

            public String toString() {
                return "FasitClient.GetApplicationConfigRequest.GetApplicationConfigRequestBuilder(applicationName=" + this.applicationName + ", environment=" + this.environment + ")";
            }
        }
    }

    public static final class GetCredentialsRequest {
        public final String domain;
        public final String environment;
        public final String userAlias;
        public final String applicationName;

        GetCredentialsRequest(String domain, String environment, String userAlias, String applicationName) {
            this.domain = domain;
            this.environment = environment;
            this.userAlias = userAlias;
            this.applicationName = applicationName;
        }

        public static GetCredentialsRequestBuilder builder() {
            return new GetCredentialsRequestBuilder();
        }

        public String getDomain() {
            return this.domain;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUserAlias() {
            return this.userAlias;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetCredentialsRequest)) {
                return false;
            }
            GetCredentialsRequest other = (GetCredentialsRequest)o;
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$environment = this.getEnvironment();
            String other$environment = other.getEnvironment();
            if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
                return false;
            }
            String this$userAlias = this.getUserAlias();
            String other$userAlias = other.getUserAlias();
            if (this$userAlias == null ? other$userAlias != null : !this$userAlias.equals(other$userAlias)) {
                return false;
            }
            String this$applicationName = this.getApplicationName();
            String other$applicationName = other.getApplicationName();
            return !(this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            String $userAlias = this.getUserAlias();
            result = result * 59 + ($userAlias == null ? 43 : $userAlias.hashCode());
            String $applicationName = this.getApplicationName();
            result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
            return result;
        }

        public String toString() {
            return "FasitClient.GetCredentialsRequest(domain=" + this.getDomain() + ", environment=" + this.getEnvironment() + ", userAlias=" + this.getUserAlias() + ", applicationName=" + this.getApplicationName() + ")";
        }

        public static class GetCredentialsRequestBuilder {
            private String domain;
            private String environment;
            private String userAlias;
            private String applicationName;

            GetCredentialsRequestBuilder() {
            }

            public GetCredentialsRequestBuilder domain(String domain) {
                this.domain = domain;
                return this;
            }

            public GetCredentialsRequestBuilder environment(String environment) {
                this.environment = environment;
                return this;
            }

            public GetCredentialsRequestBuilder userAlias(String userAlias) {
                this.userAlias = userAlias;
                return this;
            }

            public GetCredentialsRequestBuilder applicationName(String applicationName) {
                this.applicationName = applicationName;
                return this;
            }

            public GetCredentialsRequest build() {
                return new GetCredentialsRequest(this.domain, this.environment, this.userAlias, this.applicationName);
            }

            public String toString() {
                return "FasitClient.GetCredentialsRequest.GetCredentialsRequestBuilder(domain=" + this.domain + ", environment=" + this.environment + ", userAlias=" + this.userAlias + ", applicationName=" + this.applicationName + ")";
            }
        }
    }

    public static final class GetCertificateRequest {
        public final String environmentClass;
        public final String alias;

        GetCertificateRequest(String environmentClass, String alias) {
            this.environmentClass = environmentClass;
            this.alias = alias;
        }

        public static GetCertificateRequestBuilder builder() {
            return new GetCertificateRequestBuilder();
        }

        public String getEnvironmentClass() {
            return this.environmentClass;
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetCertificateRequest)) {
                return false;
            }
            GetCertificateRequest other = (GetCertificateRequest)o;
            String this$environmentClass = this.getEnvironmentClass();
            String other$environmentClass = other.getEnvironmentClass();
            if (this$environmentClass == null ? other$environmentClass != null : !this$environmentClass.equals(other$environmentClass)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $environmentClass = this.getEnvironmentClass();
            result = result * 59 + ($environmentClass == null ? 43 : $environmentClass.hashCode());
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            return result;
        }

        public String toString() {
            return "FasitClient.GetCertificateRequest(environmentClass=" + this.getEnvironmentClass() + ", alias=" + this.getAlias() + ")";
        }

        public static class GetCertificateRequestBuilder {
            private String environmentClass;
            private String alias;

            GetCertificateRequestBuilder() {
            }

            public GetCertificateRequestBuilder environmentClass(String environmentClass) {
                this.environmentClass = environmentClass;
                return this;
            }

            public GetCertificateRequestBuilder alias(String alias) {
                this.alias = alias;
                return this;
            }

            public GetCertificateRequest build() {
                return new GetCertificateRequest(this.environmentClass, this.alias);
            }

            public String toString() {
                return "FasitClient.GetCertificateRequest.GetCertificateRequestBuilder(environmentClass=" + this.environmentClass + ", alias=" + this.alias + ")";
            }
        }
    }

    public static final class GetDbCredentialsRequest {
        public final String applicationName;
        public final TestEnvironment testEnvironment;

        GetDbCredentialsRequest(String applicationName, TestEnvironment testEnvironment) {
            this.applicationName = applicationName;
            this.testEnvironment = testEnvironment;
        }

        public static GetDbCredentialsRequestBuilder builder() {
            return new GetDbCredentialsRequestBuilder();
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public TestEnvironment getTestEnvironment() {
            return this.testEnvironment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetDbCredentialsRequest)) {
                return false;
            }
            GetDbCredentialsRequest other = (GetDbCredentialsRequest)o;
            String this$applicationName = this.getApplicationName();
            String other$applicationName = other.getApplicationName();
            if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
                return false;
            }
            TestEnvironment this$testEnvironment = this.getTestEnvironment();
            TestEnvironment other$testEnvironment = other.getTestEnvironment();
            return !(this$testEnvironment == null ? other$testEnvironment != null : !((Object)((Object)this$testEnvironment)).equals((Object)other$testEnvironment));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $applicationName = this.getApplicationName();
            result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
            TestEnvironment $testEnvironment = this.getTestEnvironment();
            result = result * 59 + ($testEnvironment == null ? 43 : ((Object)((Object)$testEnvironment)).hashCode());
            return result;
        }

        public String toString() {
            return "FasitClient.GetDbCredentialsRequest(applicationName=" + this.getApplicationName() + ", testEnvironment=" + (Object)((Object)this.getTestEnvironment()) + ")";
        }

        public static class GetDbCredentialsRequestBuilder {
            private String applicationName;
            private TestEnvironment testEnvironment;

            GetDbCredentialsRequestBuilder() {
            }

            public GetDbCredentialsRequestBuilder applicationName(String applicationName) {
                this.applicationName = applicationName;
                return this;
            }

            public GetDbCredentialsRequestBuilder testEnvironment(TestEnvironment testEnvironment) {
                this.testEnvironment = testEnvironment;
                return this;
            }

            public GetDbCredentialsRequest build() {
                return new GetDbCredentialsRequest(this.applicationName, this.testEnvironment);
            }

            public String toString() {
                return "FasitClient.GetDbCredentialsRequest.GetDbCredentialsRequestBuilder(applicationName=" + this.applicationName + ", testEnvironment=" + (Object)((Object)this.testEnvironment) + ")";
            }
        }
    }

    public static final class GetBaseUrlRequest {
        public final String environment;
        public final String domain;
        public final String baseUrlAlias;
        public final String application;

        GetBaseUrlRequest(String environment, String domain, String baseUrlAlias, String application) {
            this.environment = environment;
            this.domain = domain;
            this.baseUrlAlias = baseUrlAlias;
            this.application = application;
        }

        public static GetBaseUrlRequestBuilder builder() {
            return new GetBaseUrlRequestBuilder();
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getBaseUrlAlias() {
            return this.baseUrlAlias;
        }

        public String getApplication() {
            return this.application;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetBaseUrlRequest)) {
                return false;
            }
            GetBaseUrlRequest other = (GetBaseUrlRequest)o;
            String this$environment = this.getEnvironment();
            String other$environment = other.getEnvironment();
            if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$baseUrlAlias = this.getBaseUrlAlias();
            String other$baseUrlAlias = other.getBaseUrlAlias();
            if (this$baseUrlAlias == null ? other$baseUrlAlias != null : !this$baseUrlAlias.equals(other$baseUrlAlias)) {
                return false;
            }
            String this$application = this.getApplication();
            String other$application = other.getApplication();
            return !(this$application == null ? other$application != null : !this$application.equals(other$application));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $baseUrlAlias = this.getBaseUrlAlias();
            result = result * 59 + ($baseUrlAlias == null ? 43 : $baseUrlAlias.hashCode());
            String $application = this.getApplication();
            result = result * 59 + ($application == null ? 43 : $application.hashCode());
            return result;
        }

        public String toString() {
            return "FasitClient.GetBaseUrlRequest(environment=" + this.getEnvironment() + ", domain=" + this.getDomain() + ", baseUrlAlias=" + this.getBaseUrlAlias() + ", application=" + this.getApplication() + ")";
        }

        public static class GetBaseUrlRequestBuilder {
            private String environment;
            private String domain;
            private String baseUrlAlias;
            private String application;

            GetBaseUrlRequestBuilder() {
            }

            public GetBaseUrlRequestBuilder environment(String environment) {
                this.environment = environment;
                return this;
            }

            public GetBaseUrlRequestBuilder domain(String domain) {
                this.domain = domain;
                return this;
            }

            public GetBaseUrlRequestBuilder baseUrlAlias(String baseUrlAlias) {
                this.baseUrlAlias = baseUrlAlias;
                return this;
            }

            public GetBaseUrlRequestBuilder application(String application) {
                this.application = application;
                return this;
            }

            public GetBaseUrlRequest build() {
                return new GetBaseUrlRequest(this.environment, this.domain, this.baseUrlAlias, this.application);
            }

            public String toString() {
                return "FasitClient.GetBaseUrlRequest.GetBaseUrlRequestBuilder(environment=" + this.environment + ", domain=" + this.domain + ", baseUrlAlias=" + this.baseUrlAlias + ", application=" + this.application + ")";
            }
        }
    }
}

