/*
 * Decompiled with CFR 0.152.
 */
package no.nav.fasit.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import no.nav.fasit.ApplicationConfig;
import no.nav.fasit.ApplicationProperties;
import no.nav.fasit.AzureOidcConfig;
import no.nav.fasit.DbCredentials;
import no.nav.fasit.FasitUtils;
import no.nav.fasit.LdapConfig;
import no.nav.fasit.LoadBalancerConfig;
import no.nav.fasit.OpenAmConfig;
import no.nav.fasit.Queue;
import no.nav.fasit.QueueManager;
import no.nav.fasit.ServiceUser;
import no.nav.fasit.ServiceUserCertificate;
import no.nav.fasit.WebServiceEndpoint;
import no.nav.fasit.client.ApplicationPropertiesDTO;
import no.nav.fasit.client.FasitClient;
import no.nav.fasit.client.LDAPDTO;
import no.nav.fasit.client.LoadBalancerConfigDTO;
import no.nav.fasit.client.RestServiceDTO;
import no.nav.fasit.client.WebServiceEndpointDTO;
import no.nav.fasit.dto.ApplicationInstance;
import no.nav.fasit.dto.DataSourceResource;
import no.nav.fasit.dto.QueueDTO;
import no.nav.fasit.dto.QueueManagerDTO;
import no.nav.fasit.dto.Resource;
import no.nav.fasit.dto.RestService;
import no.nav.json.JsonProvider;
import no.nav.sbl.rest.RestUtils;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FasitClientImpl
implements FasitClient {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(FasitClientImpl.class);
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(FasitClientImpl.class);
    private static final ObjectMapper objectMapper = JsonProvider.createObjectMapper();

    @Override
    public String getBaseUrl(FasitClient.GetBaseUrlRequest getBaseUrlRequest) {
        String resourceUrl = String.format("https://fasit.adeo.no/conf/resources/bestmatch?envName=%s&domain=%s&type=BaseUrl&alias=%s&app=%s", getBaseUrlRequest.environment, getBaseUrlRequest.domain, getBaseUrlRequest.baseUrlAlias, getBaseUrlRequest.application);
        Document document = FasitClientImpl.fetchXml(resourceUrl);
        return FasitClientImpl.extractStringProperty(document, "url");
    }

    @Override
    public OpenAmConfig getOpenAmConfig(String environment) {
        String resourceUrl = String.format("https://fasit.adeo.no/conf/resources/bestmatch?envName=%s&domain=%s&type=OpenAm&alias=openam&app=fasit", environment, FasitUtils.getOeraLocal(environment));
        Document document = FasitClientImpl.fetchXml(resourceUrl);
        FasitUtils.UsernameAndPassword usernameAndPassword = FasitClientImpl.getUsernameAndPassword(document);
        OpenAmConfig openAmConfig = new OpenAmConfig().setUsername(usernameAndPassword.getUsername()).setPassword(usernameAndPassword.getPassword()).setRestUrl(FasitClientImpl.extractStringProperty(document, "restUrl")).setLogoutUrl(FasitClientImpl.extractStringProperty(document, "logoutUrl"));
        return openAmConfig;
    }

    @Override
    public AzureOidcConfig getAzureOidcConfig(String alias, String envClass, FasitUtils.Zone zone) {
        String url = String.format("https://fasit.adeo.no/api/v2/resources?alias=%s&type=AzureOIDC&environmentclass=%s&zone=%s&usage=false&page=0&pr_page=100", alias, envClass, zone.name().toLowerCase());
        List<AzureOidcConfig> configs = FasitClientImpl.fetchJsonObjects(url, AzureOidcConfig.class);
        return (AzureOidcConfig)configs.stream().findFirst().orElseThrow(RuntimeException::new);
    }

    @Override
    public DbCredentials getDbCredentials(FasitClient.GetDbCredentialsRequest getDbCredentialsRequest) {
        List<ApplicationInstance> applications = FasitClientImpl.fetchJsonObjects(String.format("https://fasit.adeo.no/api/v2/applicationinstances/application/%s", getDbCredentialsRequest.applicationName), ApplicationInstance.class);
        ApplicationInstance application = applications.stream().filter(applicationInstance -> getDbCredentialsRequest.testEnvironment.matcher(applicationInstance.getEnvironment())).findAny().orElseThrow(IllegalStateException::new);
        Resource dataSourceRef = application.getUsedresources().stream().filter(resource -> "datasource".equals(resource.getType())).findAny().orElseThrow(IllegalStateException::new);
        DataSourceResource dataSourceResource = FasitClientImpl.fetchJsonObject(dataSourceRef.ref, DataSourceResource.class);
        return new DbCredentials().setUrl(dataSourceResource.properties.url).setUsername(dataSourceResource.properties.username).setPassword(FasitClientImpl.getPassword(dataSourceResource.secrets.password.ref));
    }

    @Override
    public ServiceUser getCredentials(FasitClient.GetCredentialsRequest getCredentialsRequest) {
        String resourceUrl = String.format("https://fasit.adeo.no/conf/resources/bestmatch?envName=%s&domain=%s&type=Credential&alias=%s&app=%s", getCredentialsRequest.environment, getCredentialsRequest.domain, getCredentialsRequest.userAlias, getCredentialsRequest.applicationName);
        FasitUtils.UsernameAndPassword usernameAndPassword = FasitClientImpl.getUsernameAndPassword(resourceUrl);
        ServiceUser serviceUser = new ServiceUser().setUsername(usernameAndPassword.getUsername()).setPassword(usernameAndPassword.getPassword()).setEnvironment(getCredentialsRequest.environment).setDomain(getCredentialsRequest.domain);
        LOG.info("{} = {}", (Object)getCredentialsRequest.userAlias, (Object)serviceUser);
        return serviceUser;
    }

    @Override
    public ServiceUserCertificate getCertificate(FasitClient.GetCertificateRequest getCertificateRequest) {
        Document document = FasitClientImpl.fetchXml(String.format("https://fasit.adeo.no/conf/resources?envClass=%s&type=Certificate&alias=%s&bestmatch=true", getCertificateRequest.environmentClass, getCertificateRequest.alias));
        String alias = FasitClientImpl.extractStringProperty(document, "keystorealias");
        String password = FasitClientImpl.fetchJson(FasitClientImpl.extractStringProperty(document, "keystorepassword"));
        byte[] keystore = FasitClientImpl.fetchBytes(FasitClientImpl.extractStringProperty(document, "keystore"));
        return new ServiceUserCertificate().setKeystorealias(alias).setKeystorepassword(password).setKeystore(keystore);
    }

    @Override
    public List<RestService> getRestServices(String alias) {
        return FasitClientImpl.httpClient(client -> ((List)client.target("https://fasit.adeo.no/api/v2/resources").queryParam("type", new Object[]{"RestService"}).queryParam("alias", new Object[]{alias}).queryParam("usage", new Object[]{true}).request().get(RestServiceDTO.LIST_TYPE)).stream().map(dto -> RestService.builder().alias(dto.getAlias()).url(dto.getUrl()).application(dto.getApplication()).environment(dto.getEnvironment()).environmentClass(dto.getEnvironmentClass()).zone(dto.getZone()).build()).collect(Collectors.toList()));
    }

    @Override
    public WebServiceEndpoint getWebServiceEndpoint(String alias, String environment) {
        return FasitClientImpl.httpClient(client -> ((List)client.target("https://fasit.adeo.no/api/v2/resources").queryParam("type", new Object[]{"WebServiceEndpoint"}).queryParam("environment", new Object[]{environment}).queryParam("alias", new Object[]{alias}).queryParam("usage", new Object[]{true}).request().get(WebServiceEndpointDTO.LIST_TYPE)).stream().findFirst().map(dto -> new WebServiceEndpoint().setUrl(dto.properties.endpointUrl)).orElseThrow(() -> new IllegalStateException(String.format("fant ikke '%s' i environment '%s'", alias, environment))));
    }

    @Override
    public ApplicationConfig getApplicationConfig(FasitClient.GetApplicationConfigRequest getApplicationConfigRequest) {
        ApplicationConfig applicationConfig = new ApplicationConfig();
        JsonNode jsonNode = objectMapper.readTree(FasitClientImpl.fetchJson(String.format("https://fasit.adeo.no/conf/environments/%s/applications/%s", getApplicationConfigRequest.environment, getApplicationConfigRequest.applicationName)));
        JsonNode cluster = jsonNode.get("cluster");
        applicationConfig.domain = cluster.get("domain").textValue();
        JsonNode nodes = cluster.get("nodes");
        for (JsonNode node : nodes) {
            applicationConfig.hostname = node.get("hostname").textValue();
            applicationConfig.deployerUsername = node.get("username").textValue();
            applicationConfig.deployerPasswordUrl = node.get("passwordref").textValue();
        }
        LOG.info("{} = {}", (Object)getApplicationConfigRequest.applicationName, (Object)applicationConfig);
        return applicationConfig;
    }

    @Override
    public List<LoadBalancerConfig> getLoadbalancerConfig(String alias) {
        return FasitClientImpl.httpClient(client -> ((List)client.target("https://fasit.adeo.no/api/v2/resources").queryParam("type", new Object[]{"LoadBalancerConfig"}).queryParam("alias", new Object[]{alias}).queryParam("usage", new Object[]{true}).request().get(LoadBalancerConfigDTO.LIST_TYPE)).stream().filter(dto -> alias != null && alias.equals(dto.alias)).map(dto -> new LoadBalancerConfig().setContextRoots(dto.properties.contextRoots).setUrl(dto.properties.url).setEnvironment(dto.scope.environment)).collect(Collectors.toList()));
    }

    @Override
    public LdapConfig getLdapConfig(String environmentClass) {
        return FasitClientImpl.httpClient(client -> ((List)client.target("https://fasit.adeo.no/api/v2/resources").queryParam("type", new Object[]{"LDAP"}).queryParam("alias", new Object[]{"ldap"}).queryParam("usage", new Object[]{true}).request().get(LDAPDTO.LIST_TYPE)).stream().filter(p -> environmentClass.equals(p.scope.environmentclass) && "ldap".equals(p.alias) && "fss".equals(p.scope.zone)).findFirst().map(dto -> new LdapConfig().setUrl(dto.properties.url).setBaseDN(dto.properties.basedn).setUsername(dto.properties.username).setPassword(FasitClientImpl.getPassword(dto.secrets.password.ref))).orElseThrow(() -> new IllegalStateException("fant ikke ldap i environmentClass: " + environmentClass)));
    }

    @Override
    public List<Queue> getQueue(FasitClient.GetQueueRequest getQueueRequest) {
        return FasitClientImpl.httpClient(client -> ((List)client.target("https://fasit.adeo.no/api/v2/resources").queryParam("type", new Object[]{"Queue"}).queryParam("alias", new Object[]{getQueueRequest.alias}).queryParam("environment", new Object[]{getQueueRequest.environment}).queryParam("usage", new Object[]{true}).request().get(QueueDTO.LIST_TYPE)).stream().map(this::queue).collect(Collectors.toList()));
    }

    private Queue queue(QueueDTO queueDTO) {
        QueueDTO.Properties properties = queueDTO.properties;
        QueueDTO.Scope scope = queueDTO.scope;
        return new Queue().setName(properties.queueName).setEnvironment(scope.environment).setEnvironmentClass(scope.environmentclass);
    }

    @Override
    public List<QueueManager> getQueueManager(FasitClient.GetQueueManagerRequest getQueueManagerRequest) {
        return FasitClientImpl.httpClient(client -> ((List)client.target("https://fasit.adeo.no/api/v2/resources").queryParam("type", new Object[]{"QueueManager"}).queryParam("alias", new Object[]{getQueueManagerRequest.alias}).queryParam("environmentclass", new Object[]{getQueueManagerRequest.environmentClass}).queryParam("zone", new Object[]{getQueueManagerRequest.zone}).queryParam("usage", new Object[]{true}).request().get(QueueManagerDTO.LIST_TYPE)).stream().map(this::queueManager).collect(Collectors.toList()));
    }

    private QueueManager queueManager(QueueManagerDTO queueManagerDTO) {
        QueueManagerDTO.Properties properties = queueManagerDTO.properties;
        QueueManagerDTO.Scope scope = queueManagerDTO.scope;
        return new QueueManager().setPort(properties.port).setHostname(properties.hostname).setName(properties.name).setEnvironment(scope.environment).setEnvironmentClass(scope.environmentclass);
    }

    @Override
    public List<ApplicationProperties> getApplicationProperties(FasitClient.GetApplicationPropertiesRequest getApplicationPropertiesRequest) {
        return FasitClientImpl.httpClient(client -> ((List)client.target("https://fasit.adeo.no/api/v2/resources").queryParam("type", new Object[]{"ApplicationProperties"}).queryParam("alias", new Object[]{getApplicationPropertiesRequest.alias}).queryParam("environmentclass", new Object[]{getApplicationPropertiesRequest.environmentClass}).queryParam("usage", new Object[]{true}).request().get(ApplicationPropertiesDTO.LIST_TYPE)).stream().map(this::toProperties).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties getApplicationEnvironment(FasitClient.GetApplicationEnvironmentRequest getApplicationEnvironmentRequest) {
        ApplicationConfig applicationConfig = this.getApplicationConfig(FasitClient.GetApplicationConfigRequest.builder().environment(getApplicationEnvironmentRequest.environment).applicationName(getApplicationEnvironmentRequest.applicationName).build());
        JSch.setLogger((Logger)new Logger(){

            public boolean isEnabled(int level) {
                return true;
            }

            public void log(int level, String message) {
                LOG.info(message);
            }
        });
        JSch jsch = new JSch();
        String hostname = applicationConfig.hostname;
        Session session = jsch.getSession(applicationConfig.deployerUsername, hostname);
        try {
            Properties properties;
            session.setPassword(FasitClientImpl.getPassword(applicationConfig.deployerPasswordUrl));
            session.setConfig("StrictHostKeyChecking", Boolean.FALSE.toString());
            session.setConfig("PreferredAuthentications", "password");
            session.connect();
            ChannelExec shell = (ChannelExec)session.openChannel("exec");
            try {
                String command = String.format("sudo cat /app/%s/configuration/environment.properties", getApplicationEnvironmentRequest.applicationName);
                shell.setCommand(command);
                shell.setErrStream((OutputStream)System.err);
                LOG.info("connecting...");
                shell.connect();
                int attempt = 0;
                while (!shell.isConnected() && attempt++ < 5) {
                    Thread.sleep(100L);
                }
                if (!shell.isConnected()) {
                    throw new IllegalStateException();
                }
                LOG.info("connected!");
                Properties properties2 = new Properties();
                properties2.load(shell.getInputStream());
                if (properties2.isEmpty()) {
                    throw new IllegalStateException(String.format("[%s] mot %s gav ingen properties", command, hostname));
                }
                properties = properties2;
            }
            catch (Throwable throwable) {
                shell.disconnect();
                throw throwable;
            }
            shell.disconnect();
            return properties;
        }
        finally {
            session.disconnect();
        }
    }

    private static Document fetchXml(String resourceUrl) {
        LOG.info("Fetching xml: {}", (Object)resourceUrl);
        return FasitClientImpl.httpClient(httpClient -> {
            Response contentResponse = httpClient.target(resourceUrl).request().get();
            String resourceXml = FasitClientImpl.getContent(contentResponse);
            LOG.info(resourceXml);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new InputSource(new StringReader(resourceXml)));
        });
    }

    public static <T> T httpClient(With<Client, T> httpClientConsumer) {
        int attempt = 0;
        while (true) {
            try {
                return FasitClientImpl.invokeHttpClient(httpClientConsumer);
            }
            catch (Throwable throwable) {
                if (throwable instanceof IllegalStateException || throwable instanceof NotAuthorizedException) {
                    throw throwable;
                }
                LOG.warn("feil mot fasit");
                LOG.warn(throwable.getMessage(), throwable);
                Thread.sleep(5000L);
                if (attempt++ < 5) continue;
                throw new IllegalStateException("Klarer ikke \u00e5 snakke med Fasit");
            }
            break;
        }
    }

    private static <T> T invokeHttpClient(With<Client, T> httpClientConsumer) {
        return (T)RestUtils.withClient((RestUtils.RestConfig)RestUtils.DEFAULT_CONFIG.withDisableMetrics(true), httpClient -> {
            httpClient.register((Object)HttpAuthenticationFeature.basic((String)FasitUtils.getFasitUser(), (String)FasitUtils.getFasitPassword()));
            return httpClientConsumer.withSafe((Client)httpClient);
        });
    }

    private static String extractStringProperty(Document document, String propertyName) {
        NodeList properties = document.getElementsByTagName("property");
        return FasitClientImpl.extractStringProperty(properties, propertyName);
    }

    private static String extractStringProperty(NodeList nodeList, String propertyName) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            String aPropertyName = item.getAttributes().getNamedItem("name").getTextContent();
            if (!aPropertyName.equals(propertyName)) continue;
            return item.getFirstChild().getTextContent();
        }
        throw new IllegalStateException(String.format("fant ikke property '%s' i respons", propertyName));
    }

    private static FasitUtils.UsernameAndPassword getUsernameAndPassword(String resourceUrl) {
        return FasitClientImpl.getUsernameAndPassword(FasitClientImpl.fetchXml(resourceUrl));
    }

    private static FasitUtils.UsernameAndPassword getUsernameAndPassword(Document document) {
        FasitUtils.UsernameAndPassword usernameAndPassword = new FasitUtils.UsernameAndPassword();
        usernameAndPassword.setUsername(FasitClientImpl.extractStringProperty(document, "username"));
        String passwordUrl = FasitClientImpl.extractStringProperty(document, "password");
        usernameAndPassword.setPassword(FasitClientImpl.getPassword(passwordUrl));
        return usernameAndPassword;
    }

    private static String getPassword(String passwordUrl) {
        LOG.info("fetching password from: {}", (Object)passwordUrl);
        return FasitClientImpl.httpClient(httpClient -> FasitClientImpl.getContent(httpClient.target(passwordUrl).request().get()));
    }

    private static String getContent(Response contentResponse) {
        String contentAsString = (String)contentResponse.readEntity(String.class);
        if (contentResponse.getStatus() != 200) {
            throw new IllegalStateException(contentAsString);
        }
        return contentAsString;
    }

    private static String fetchJson(String url) {
        LOG.info("Fetching json: {}", (Object)url);
        String json = FasitClientImpl.httpClient(httpClient -> (String)httpClient.target(url).request(new String[]{"application/json"}).get(String.class));
        LOG.info(json.replaceAll("\n", ""));
        return json;
    }

    private static byte[] fetchBytes(String url) {
        return FasitClientImpl.httpClient(httpClient -> (byte[])httpClient.target(url).request().get(byte[].class));
    }

    private ApplicationProperties toProperties(ApplicationPropertiesDTO applicationPropertiesDTO) {
        ApplicationProperties properties = ApplicationProperties.builder().environment(applicationPropertiesDTO.scope.environment).environmentClass(applicationPropertiesDTO.scope.environmentclass).build();
        properties.load(new ByteArrayInputStream(applicationPropertiesDTO.properties.applicationProperties.getBytes()));
        return properties;
    }

    private static <T> T fetchJsonObject(String url, Class<T> type) {
        return (T)objectMapper.readValue(FasitClientImpl.fetchJson(url), type);
    }

    private static <T> List<T> fetchJsonObjects(String url, Class<T> type) {
        return (List)objectMapper.readValue(FasitClientImpl.fetchJson(url), (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, type));
    }

    @FunctionalInterface
    public static interface With<T, R> {
        default public R withSafe(T t) {
            return this.with(t);
        }

        public R with(T var1) throws Exception;
    }
}

