/*
 * Decompiled with CFR 0.152.
 */
package no.nav.fasit.client;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import no.nav.fasit.ApplicationConfig;
import no.nav.fasit.ApplicationProperties;
import no.nav.fasit.AzureOidcConfig;
import no.nav.fasit.AzureOidcConfigProperties;
import no.nav.fasit.DbCredentials;
import no.nav.fasit.FasitUtils;
import no.nav.fasit.LdapConfig;
import no.nav.fasit.LoadBalancerConfig;
import no.nav.fasit.OpenAmConfig;
import no.nav.fasit.Queue;
import no.nav.fasit.QueueManager;
import no.nav.fasit.ServiceUser;
import no.nav.fasit.ServiceUserCertificate;
import no.nav.fasit.WebServiceEndpoint;
import no.nav.fasit.client.FasitClient;
import no.nav.fasit.dto.RestService;

public class FasitClientMock
implements FasitClient {
    @Override
    public String getBaseUrl(FasitClient.GetBaseUrlRequest getBaseUrlRequest) {
        String baseUrlAlias = getBaseUrlRequest.baseUrlAlias;
        return this.mockUrl(baseUrlAlias);
    }

    @Override
    public OpenAmConfig getOpenAmConfig(String environment) {
        throw new IllegalStateException();
    }

    @Override
    public AzureOidcConfig getAzureOidcConfig(String alias, String envClass, FasitUtils.Zone zone) {
        AzureOidcConfigProperties properties = AzureOidcConfigProperties.builder().callbackUri("test-callback-uri").clientId("test-client-id").discoveryUri("test-discovery-uri").build();
        return AzureOidcConfig.builder().properties(properties).build();
    }

    @Override
    public List<RestService> getRestServices(String alias) {
        return Collections.singletonList(RestService.builder().url(this.mockUrl(alias)).environment(FasitUtils.getDefaultEnvironment()).build());
    }

    @Override
    public DbCredentials getDbCredentials(FasitClient.GetDbCredentialsRequest getDbCredentialsRequest) {
        String url = String.format("jdbc:h2:mem:%s-0;DB_CLOSE_DELAY=-1;MODE=Oracle;", getDbCredentialsRequest.applicationName);
        return new DbCredentials().setUrl(url).setUsername("mock-user-db").setPassword("mock-password-db");
    }

    @Override
    public ServiceUserCertificate getCertificate(FasitClient.GetCertificateRequest getCertificateRequest) {
        return new ServiceUserCertificate().setKeystore(new byte[0]).setKeystorealias(getCertificateRequest.alias).setKeystorepassword("");
    }

    @Override
    public ServiceUser getCredentials(FasitClient.GetCredentialsRequest getCredentialsRequest) {
        String mockUserName = String.format("mock-user-%s", getCredentialsRequest.applicationName);
        return new ServiceUser().setUsername(mockUserName).setPassword("mock-password").setEnvironment(getCredentialsRequest.environment).setDomain(getCredentialsRequest.domain);
    }

    @Override
    public ApplicationConfig getApplicationConfig(FasitClient.GetApplicationConfigRequest getApplicationConfigRequest) {
        throw new IllegalStateException();
    }

    @Override
    public Properties getApplicationEnvironment(FasitClient.GetApplicationEnvironmentRequest getApplicationEnvironmentRequest) {
        return new Properties();
    }

    @Override
    public LdapConfig getLdapConfig(String environment) {
        throw new IllegalStateException();
    }

    @Override
    public List<Queue> getQueue(FasitClient.GetQueueRequest getQueueRequest) {
        return Collections.singletonList(new Queue().setName(getQueueRequest.alias));
    }

    @Override
    public List<QueueManager> getQueueManager(FasitClient.GetQueueManagerRequest getQueueManagerRequest) {
        return Collections.singletonList(new QueueManager().setName(getQueueManagerRequest.alias).setHostname("localhost").setPort(7676));
    }

    @Override
    public WebServiceEndpoint getWebServiceEndpoint(String alias, String environment) {
        throw new IllegalStateException();
    }

    @Override
    public List<LoadBalancerConfig> getLoadbalancerConfig(String alias) {
        throw new IllegalStateException();
    }

    @Override
    public List<ApplicationProperties> getApplicationProperties(FasitClient.GetApplicationPropertiesRequest getApplicationPropertiesRequest) {
        throw new IllegalStateException();
    }

    private String mockUrl(String alias) {
        return String.format("http://localhost:8080/mock/%s", alias);
    }
}

