/*
 * Decompiled with CFR 0.152.
 */
package no.nav.fo.feed.producer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import no.nav.fo.feed.common.Authorization;
import no.nav.fo.feed.common.FeedAuthorizationModule;
import no.nav.fo.feed.common.FeedElement;
import no.nav.fo.feed.common.FeedRequest;
import no.nav.fo.feed.common.FeedResponse;
import no.nav.fo.feed.common.FeedWebhookRequest;
import no.nav.fo.feed.common.OutInterceptor;
import no.nav.fo.feed.exception.InvalidUrlException;
import no.nav.fo.feed.producer.FeedProvider;
import no.nav.fo.feed.util.MetricsUtils;
import no.nav.fo.feed.util.UrlValidator;
import no.nav.sbl.rest.RestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedProducer<DOMAINOBJECT extends Comparable<DOMAINOBJECT>>
implements Authorization {
    private static final Logger LOG = LoggerFactory.getLogger(FeedProducer.class);
    private static final Client REST_CLIENT = RestUtils.createClient();
    private int maxPageSize;
    private final Set<String> callbackUrls = ConcurrentHashMap.newKeySet();
    private List<OutInterceptor> interceptors;
    private FeedAuthorizationModule authorizationModule;
    private FeedProvider<DOMAINOBJECT> provider;

    public FeedResponse<DOMAINOBJECT> getFeedPage(String feedname, FeedRequest request) {
        int pageSize = FeedProducer.getPageSize(request.getPageSize(), this.maxPageSize);
        String id = request.getSinceId();
        List pageElements = this.provider.fetchData(id, pageSize).sorted().limit(pageSize + 1).collect(Collectors.toList());
        if (pageElements.size() > pageSize) {
            MetricsUtils.metricEvent("fetchnotlimited", feedname);
            LOG.warn("Provider retrieved more than <pageSize> elements in response to {} for feed {}", (Object)request, (Object)feedname);
            LOG.info("This can lead to excessive resource consumption by the producer...");
        }
        long antallUnikeIder = pageElements.stream().map(FeedElement::getId).distinct().count();
        if ((long)pageElements.size() != antallUnikeIder) {
            MetricsUtils.metricEvent("duplicateid", feedname);
            LOG.warn("Found duplicate IDs in response to {} for feed {}", (Object)request, (Object)feedname);
            LOG.info("This can lead to excessive network usage between the producer and its consumers...");
        }
        if (pageElements.isEmpty()) {
            return new FeedResponse().setNextPageId(id);
        }
        String nextPageId = Optional.ofNullable(pageElements.get(pageElements.size() - 1)).map(FeedElement::getId).orElse(null);
        return new FeedResponse().setNextPageId(nextPageId).setElements(pageElements);
    }

    public Map<String, Future<Integer>> activateWebhook() {
        return this.callbackUrls.stream().collect(Collectors.toMap(Function.identity(), str -> CompletableFuture.supplyAsync(() -> this.tryActivateWebHook((String)str))));
    }

    private int tryActivateWebHook(String url) {
        try {
            Invocation.Builder request = REST_CLIENT.target(url).request();
            this.interceptors.forEach(interceptor -> interceptor.apply(request));
            LOG.debug("activate webhook til url {}", (Object)url);
            int status = request.build("HEAD").invoke().getStatus();
            if (status != 200) {
                LOG.warn("Fikk ikke forventet status fra kall til webhook. Url {}, returnert status {}", (Object)url, (Object)status);
            }
            return status;
        }
        catch (Exception e) {
            LOG.warn("Feil ved activate webhook til url {}, {}", new Object[]{url, e.getMessage(), e});
            return 500;
        }
    }

    public boolean createWebhook(FeedWebhookRequest request) {
        return Optional.ofNullable(request.callbackUrl).map(this::createWebhook).orElseThrow(InvalidUrlException::new);
    }

    @Override
    public FeedAuthorizationModule getAuthorizationModule() {
        return this.authorizationModule;
    }

    private boolean createWebhook(String callbackUrl) {
        UrlValidator.validateUrl(callbackUrl);
        return this.callbackUrls.add(callbackUrl);
    }

    private static int getPageSize(int pageSize, int maxPageSize) {
        return pageSize > maxPageSize ? maxPageSize : pageSize;
    }

    private static <DOMAINOBJECT extends Comparable<DOMAINOBJECT>> int $default$maxPageSize() {
        return 10000;
    }

    private static <DOMAINOBJECT extends Comparable<DOMAINOBJECT>> List<OutInterceptor> $default$interceptors() {
        return new ArrayList<OutInterceptor>();
    }

    private static <DOMAINOBJECT extends Comparable<DOMAINOBJECT>> FeedAuthorizationModule $default$authorizationModule() {
        return feedname -> true;
    }

    FeedProducer(int maxPageSize, List<OutInterceptor> interceptors, FeedAuthorizationModule authorizationModule, FeedProvider<DOMAINOBJECT> provider) {
        this.maxPageSize = maxPageSize;
        this.interceptors = interceptors;
        this.authorizationModule = authorizationModule;
        this.provider = provider;
    }

    public static <DOMAINOBJECT extends Comparable<DOMAINOBJECT>> FeedProducerBuilder<DOMAINOBJECT> builder() {
        return new FeedProducerBuilder();
    }

    public static class FeedProducerBuilder<DOMAINOBJECT extends Comparable<DOMAINOBJECT>> {
        private boolean maxPageSize$set;
        private int maxPageSize;
        private boolean interceptors$set;
        private List<OutInterceptor> interceptors;
        private boolean authorizationModule$set;
        private FeedAuthorizationModule authorizationModule;
        private FeedProvider<DOMAINOBJECT> provider;

        FeedProducerBuilder() {
        }

        public FeedProducerBuilder<DOMAINOBJECT> maxPageSize(int maxPageSize) {
            this.maxPageSize = maxPageSize;
            this.maxPageSize$set = true;
            return this;
        }

        public FeedProducerBuilder<DOMAINOBJECT> interceptors(List<OutInterceptor> interceptors) {
            this.interceptors = interceptors;
            this.interceptors$set = true;
            return this;
        }

        public FeedProducerBuilder<DOMAINOBJECT> authorizationModule(FeedAuthorizationModule authorizationModule) {
            this.authorizationModule = authorizationModule;
            this.authorizationModule$set = true;
            return this;
        }

        public FeedProducerBuilder<DOMAINOBJECT> provider(FeedProvider<DOMAINOBJECT> provider) {
            this.provider = provider;
            return this;
        }

        public FeedProducer<DOMAINOBJECT> build() {
            int maxPageSize = this.maxPageSize;
            if (!this.maxPageSize$set) {
                maxPageSize = FeedProducer.$default$maxPageSize();
            }
            List interceptors = this.interceptors;
            if (!this.interceptors$set) {
                interceptors = FeedProducer.$default$interceptors();
            }
            FeedAuthorizationModule authorizationModule = this.authorizationModule;
            if (!this.authorizationModule$set) {
                authorizationModule = FeedProducer.$default$authorizationModule();
            }
            return new FeedProducer<DOMAINOBJECT>(maxPageSize, interceptors, authorizationModule, this.provider);
        }

        public String toString() {
            return "FeedProducer.FeedProducerBuilder(maxPageSize=" + this.maxPageSize + ", interceptors=" + this.interceptors + ", authorizationModule=" + this.authorizationModule + ", provider=" + this.provider + ")";
        }
    }
}

