/*
 * Decompiled with CFR 0.152.
 */
package no.nav.fo.feed.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import no.nav.fo.feed.common.FeedAuthorizationModule;
import no.nav.fo.feed.common.OutInterceptor;
import no.nav.fo.feed.consumer.FeedCallback;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;

public class FeedConsumerConfig<DOMAINOBJECT> {
    public final Class<DOMAINOBJECT> domainobject;
    public final Supplier<String> lastEntrySupplier;
    public final String host;
    public final String feedName;
    public final ScheduleCreator pollingConfig;
    public final WebhookScheduleCreator webhookPollingConfig;
    FeedCallback<DOMAINOBJECT> callback;
    List<OutInterceptor> interceptors = new ArrayList<OutInterceptor>();
    FeedAuthorizationModule authorizationModule = feedname -> true;
    int pageSize;
    LockingTaskExecutor lockExecutor;
    int lockHoldingLimitInMilliSeconds;

    public FeedConsumerConfig(BaseConfig<DOMAINOBJECT> baseConfig, ScheduleCreator pollingConfig) {
        this(baseConfig, pollingConfig, null);
    }

    public FeedConsumerConfig(BaseConfig<DOMAINOBJECT> baseConfig, ScheduleCreator pollingConfig, WebhookScheduleCreator webhookPollingConfig) {
        this.domainobject = baseConfig.domainobject;
        this.lastEntrySupplier = baseConfig.lastEntrySupplier;
        this.host = baseConfig.host;
        this.feedName = baseConfig.feedName;
        this.pollingConfig = pollingConfig;
        this.webhookPollingConfig = webhookPollingConfig;
        this.pageSize = 100;
    }

    public FeedConsumerConfig<DOMAINOBJECT> authorizatioModule(FeedAuthorizationModule authorizationModule) {
        this.authorizationModule = authorizationModule;
        return this;
    }

    public FeedConsumerConfig<DOMAINOBJECT> interceptors(List<OutInterceptor> interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public FeedConsumerConfig<DOMAINOBJECT> callback(FeedCallback<DOMAINOBJECT> callback) {
        this.callback = callback;
        return this;
    }

    public FeedConsumerConfig<DOMAINOBJECT> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public FeedConsumerConfig<DOMAINOBJECT> lockProvider(LockProvider lockProvider, int lockHoldingLimitInMilliSeconds) {
        return this.lockExecutor((LockingTaskExecutor)new DefaultLockingTaskExecutor(lockProvider), lockHoldingLimitInMilliSeconds);
    }

    public FeedConsumerConfig<DOMAINOBJECT> lockExecutor(LockingTaskExecutor lockExecutor, int lockHoldingLimitInMilliSeconds) {
        this.lockExecutor = lockExecutor;
        this.lockHoldingLimitInMilliSeconds = lockHoldingLimitInMilliSeconds;
        return this;
    }

    public static class SimpleWebhookPollingConfig
    extends WebhookScheduleCreator {
        public SimpleWebhookPollingConfig(int webhookPollingIntervalInSeconds, String apiRootPath) {
            super((ScheduleBuilder<?>)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(webhookPollingIntervalInSeconds).repeatForever(), apiRootPath);
        }
    }

    public static class CronWebhookPollingConfig
    extends WebhookScheduleCreator {
        public CronWebhookPollingConfig(String webhookPollingInterval, String apiRootPath) {
            super((ScheduleBuilder<?>)CronScheduleBuilder.cronSchedule((String)webhookPollingInterval), apiRootPath);
        }
    }

    public static class SimplePollingConfig
    extends ScheduleCreator {
        public SimplePollingConfig(int pollingIntervalInSeconds) {
            super((ScheduleBuilder<?>)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(pollingIntervalInSeconds).repeatForever());
        }
    }

    public static class CronPollingConfig
    extends ScheduleCreator {
        public CronPollingConfig(String pollingInterval) {
            super((ScheduleBuilder<?>)CronScheduleBuilder.cronSchedule((String)pollingInterval));
        }
    }

    public static class WebhookScheduleCreator
    extends ScheduleCreator {
        public final String apiRootPath;

        public WebhookScheduleCreator(ScheduleBuilder<?> builder, String apiRootPath) {
            super(builder);
            this.apiRootPath = apiRootPath;
        }
    }

    public static class ScheduleCreator {
        public final ScheduleBuilder<?> scheduleBuilder;

        public ScheduleCreator(ScheduleBuilder<?> scheduleBuilder) {
            this.scheduleBuilder = scheduleBuilder;
        }
    }

    public static class BaseConfig<DOMAINOBJECT> {
        public final Class<DOMAINOBJECT> domainobject;
        public final Supplier<String> lastEntrySupplier;
        public final String host;
        public final String feedName;

        public BaseConfig(Class<DOMAINOBJECT> domainobject, Supplier<String> lastEntrySupplier, String host, String feedName) {
            this.domainobject = domainobject;
            this.lastEntrySupplier = lastEntrySupplier;
            this.host = host;
            this.feedName = feedName;
        }
    }
}

