/*
 * Decompiled with CFR 0.152.
 */
package no.nav.fo.feed.util;

import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.nav.sbl.util.EnvironmentUtils;

public class UrlUtils {
    public static final String FEED_LOKALT_CALLBACK_HOST_PROPERTY_NAME = "feed.lokalt.callback.host";
    public static final String QUERY_PARAM_PAGE_SIZE = "page_size";
    public static final String QUERY_PARAM_ID = "id";
    private static Pattern pattern = Pattern.compile("([^:]\\/)\\/+");

    public static String callbackUrl(String root, String feedname) {
        return UrlUtils.asUrl(UrlUtils.getHost(), root, "feed", feedname);
    }

    private static String getHost() {
        return EnvironmentUtils.getOptionalProperty((String)FEED_LOKALT_CALLBACK_HOST_PROPERTY_NAME, (String[])new String[0]).orElseGet(() -> {
            switch (EnvironmentUtils.getEnvironmentClass()) {
                case T: 
                case Q: {
                    return String.format("https://app-%s.adeo.no", EnvironmentUtils.requireEnvironmentName());
                }
            }
            return "https://app.adeo.no";
        });
    }

    public static String asUrl(String ... s) {
        String url = Stream.of(s).collect(Collectors.joining("/"));
        return pattern.matcher(url).replaceAll("$1");
    }
}

