/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.feed.consumer;

import java.lang.reflect.Type;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.javacrumbs.shedlock.core.LockConfiguration;
import no.nav.common.feed.common.Authorization;
import no.nav.common.feed.common.FeedAuthorizationModule;
import no.nav.common.feed.common.FeedElement;
import no.nav.common.feed.common.FeedParameterizedType;
import no.nav.common.feed.common.FeedResponse;
import no.nav.common.feed.common.FeedWebhookRequest;
import no.nav.common.feed.consumer.FeedCallback;
import no.nav.common.feed.consumer.FeedConsumerConfig;
import no.nav.common.feed.consumer.FeedPoller;
import no.nav.common.feed.util.UrlUtils;
import no.nav.common.health.HealthCheck;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.rest.RestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class FeedConsumer<DOMAINOBJECT extends Comparable<DOMAINOBJECT>>
implements HealthCheck,
Authorization,
ApplicationListener<ContextClosedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(FeedConsumer.class);
    private final FeedConsumerConfig<DOMAINOBJECT> config;
    private int lastResponseHash;
    private static final Client REST_CLIENT = RestUtils.createClient();

    public FeedConsumer(FeedConsumerConfig<DOMAINOBJECT> config) {
        String feedName = config.feedName;
        String host = config.host;
        this.config = config;
        FeedPoller.createScheduledJob(feedName, host, config.pollingConfig, this.runWithLock(feedName, this::poll));
        FeedPoller.createScheduledJob(feedName + "/webhook", host, config.webhookPollingConfig, this::registerWebhook);
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        FeedPoller.shutdown();
    }

    public boolean webhookCallback() {
        if (this.config.webhookPollingConfig == null) {
            return false;
        }
        CompletableFuture.runAsync(this.runWithLock(this.config.feedName, this::poll));
        return true;
    }

    public void addCallback(FeedCallback callback) {
        this.config.callback(callback);
    }

    void registerWebhook() {
        String callbackUrl = UrlUtils.callbackUrl(this.config.webhookPollingConfig.apiRootPath, this.config.feedName);
        FeedWebhookRequest body = new FeedWebhookRequest().setCallbackUrl(callbackUrl);
        Entity entity = Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Invocation.Builder request = REST_CLIENT.target(UrlUtils.asUrl(this.config.host, "feed", this.config.feedName, "webhook")).request();
        this.config.interceptors.forEach(interceptor -> interceptor.apply(request));
        Response response = request.buildPut(entity).invoke();
        int responseStatus = response.getStatus();
        if (responseStatus == 201) {
            LOG.info("Webhook opprettet hos produsent!");
        } else if (responseStatus != 200) {
            LOG.warn("Endepunkt for opprettelse av webhook returnerte feilkode {}", (Object)responseStatus);
        }
    }

    public synchronized Response poll() {
        Response response = this.fetchChanges();
        if (response.getStatus() != 200) {
            LOG.warn("Endepunkt for polling av feed returnerte feilkode {}", (Object)response.getStatus());
        } else {
            FeedParameterizedType type = new FeedParameterizedType(this.config.domainobject);
            FeedResponse entity = (FeedResponse)response.readEntity(new GenericType((Type)type));
            List elements = entity.getElements();
            if (elements != null && !elements.isEmpty()) {
                List data = elements.stream().map(FeedElement::getElement).collect(Collectors.toList());
                if (entity.hashCode() != this.lastResponseHash) {
                    this.config.callback.call(entity.getNextPageId(), data);
                }
                this.lastResponseHash = entity.hashCode();
            }
        }
        return response;
    }

    Response fetchChanges() {
        String lastEntry = this.config.lastEntrySupplier.get();
        Invocation.Builder request = REST_CLIENT.target(this.getTargetUrl()).queryParam("id", new Object[]{lastEntry}).queryParam("page_size", new Object[]{this.config.pageSize}).request();
        this.config.interceptors.forEach(interceptor -> interceptor.apply(request));
        return request.buildGet().invoke();
    }

    private String getTargetUrl() {
        return UrlUtils.asUrl(this.config.host, "feed", this.config.feedName);
    }

    @Override
    public FeedAuthorizationModule getAuthorizationModule() {
        return this.config.authorizationModule;
    }

    private Runnable runWithLock(String lockname, Runnable task) {
        return () -> {
            if (this.config.lockExecutor == null) {
                task.run();
            } else {
                Instant lockAtMostUntil = Instant.now().plusMillis(this.config.lockHoldingLimitInMilliSeconds);
                LockConfiguration lockConfiguration = new LockConfiguration(lockname, lockAtMostUntil);
                this.config.lockExecutor.executeWithLock(task, lockConfiguration);
            }
        };
    }

    public HealthCheckResult checkHealth() {
        try {
            int status = this.fetchChanges().getStatus();
            if (status == 200) {
                return HealthCheckResult.healthy();
            }
            return HealthCheckResult.unhealthy((String)("Feed helsesjekk feilet med status " + status));
        }
        catch (Throwable e) {
            return HealthCheckResult.unhealthy((Throwable)e);
        }
    }
}

