/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.feed.consumer;

import java.util.HashMap;
import java.util.Map;
import no.nav.common.feed.consumer.FeedConsumerConfig;
import no.nav.common.feed.util.UrlUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

@DisallowConcurrentExecution
public class FeedPoller
implements Job {
    private static Scheduler scheduler;
    private static Map<String, Runnable> jobs;

    public static synchronized Scheduler getScheduler() {
        if (scheduler == null) {
            scheduler = new StdSchedulerFactory().getScheduler();
            scheduler.start();
        }
        return scheduler;
    }

    public void execute(JobExecutionContext context) {
        JobKey jobkey = context.getJobDetail().getKey();
        String name = UrlUtils.asUrl(jobkey.getGroup(), jobkey.getName());
        jobs.getOrDefault(name, () -> {}).run();
    }

    public static void createScheduledJob(String name, String group, FeedConsumerConfig.ScheduleCreator scheduleCreator, Runnable jobImpl) {
        if (scheduleCreator != null) {
            JobDetail job = JobBuilder.newJob(FeedPoller.class).withIdentity(name, group).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, group).withSchedule(scheduleCreator.scheduleBuilder).build();
            FeedPoller.getScheduler().scheduleJob(job, trigger);
            String jobname = UrlUtils.asUrl(group, name);
            jobs.putIfAbsent(jobname, jobImpl);
        }
    }

    public static void shutdown() {
        if (scheduler != null) {
            scheduler.shutdown();
            jobs.clear();
            scheduler = null;
        }
    }

    static {
        jobs = new HashMap<String, Runnable>();
    }
}

