/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.feed.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import no.nav.common.feed.common.Authorization;
import no.nav.common.feed.common.FeedRequest;
import no.nav.common.feed.common.FeedResponse;
import no.nav.common.feed.common.FeedWebhookRequest;
import no.nav.common.feed.consumer.FeedConsumer;
import no.nav.common.feed.exception.MissingIdException;
import no.nav.common.feed.producer.FeedProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="feed")
public class FeedController {
    private static final Logger LOG = LoggerFactory.getLogger(FeedController.class);
    private static final int DEFAULT_PAGE_SIZE = 100;
    private Map<String, FeedProducer> producers = new HashMap<String, FeedProducer>();
    private Map<String, FeedConsumer> consumers = new HashMap<String, FeedConsumer>();

    public <DOMAINOBJECT extends Comparable<DOMAINOBJECT>> FeedController addFeed(String serverFeedname, FeedProducer<DOMAINOBJECT> producer) {
        LOG.info("ny feed. navn={}", (Object)serverFeedname);
        this.producers.put(serverFeedname, producer);
        return this;
    }

    public <DOMAINOBJECT extends Comparable<DOMAINOBJECT>> FeedController addFeed(String clientFeedname, FeedConsumer<DOMAINOBJECT> consumer) {
        LOG.info("ny feed-klient. navn={}", (Object)clientFeedname);
        this.consumers.put(clientFeedname, consumer);
        return this;
    }

    public FeedController() {
        LOG.info("starter");
    }

    @GET
    public List<String> getFeeds() {
        return new ArrayList<String>(this.producers.keySet());
    }

    @PUT
    @Path(value="{name}/webhook")
    public Response registerWebhook(FeedWebhookRequest request, @PathParam(value="name") String name) {
        return Optional.ofNullable(this.producers.get(name)).map(producer -> this.authorizeRequest(producer, name)).map(feed -> feed.createWebhook(request)).map(created -> Response.status((int)(created != false ? 201 : 200))).orElse(Response.status((Response.Status)Response.Status.BAD_REQUEST)).build();
    }

    @GET
    @Path(value="{name}")
    public FeedResponse<?> getFeeddata(@PathParam(value="name") String name, @QueryParam(value="id") String id, @QueryParam(value="page_size") Integer pageSize) {
        FeedProducer feedProducer = Optional.ofNullable(this.producers.get(name)).orElseThrow(NotFoundException::new);
        this.authorizeRequest(feedProducer, name);
        FeedRequest request = new FeedRequest().setSinceId(Optional.ofNullable(id).orElseThrow(MissingIdException::new)).setPageSize(Optional.ofNullable(pageSize).orElse(100));
        return feedProducer.getFeedPage(name, request);
    }

    @GET
    @Path(value="/feedname")
    public Response getFeedNames() {
        return Response.ok().entity(this.producers.keySet()).build();
    }

    @HEAD
    @Path(value="{name}")
    public Response webhookCallback(@PathParam(value="name") String feedname) {
        return Optional.ofNullable(feedname).map(name -> this.consumers.get(name)).map(consumer -> this.authorizeRequest(consumer, feedname)).map(FeedConsumer::webhookCallback).map(hadCallback -> Response.status((int)(hadCallback != false ? 200 : 404))).orElse(Response.status((int)404)).build();
    }

    private <T extends Authorization> T authorizeRequest(T feed, String name) {
        if (!feed.getAuthorizationModule().isRequestAuthorized(name)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return feed;
    }
}

