/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql.mapping;

import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.function.Function;
import no.nav.sbl.sql.mapping.QueryMapping;

class TypeMapping {
    static Map<Class<?>, Map<Class<?>, Deserializer<?, ?>>> typemappers = HashMap.empty();

    TypeMapping() {
    }

    static <FROM, TO> void register(Class<FROM> fromCls, Class<TO> toCls, Deserializer<FROM, TO> deserializer) {
        Map toMap = (Map)typemappers.get(fromCls).getOrElse((Object)HashMap.empty());
        toMap = toMap.put(toCls, deserializer);
        typemappers = typemappers.put(fromCls, (Object)toMap);
    }

    static <FROM, TO> Option<Deserializer<FROM, TO>> getDeserializer(QueryMapping.InternalColumn<FROM, TO> column) {
        if (column.from == column.to) {
            return Option.of(from -> from);
        }
        Deserializer deserializer = (Deserializer)typemappers.get(column.from).flatMap(toMap -> toMap.get(column.to)).getOrNull();
        return Option.of((Object)deserializer);
    }

    static <TO, FROM> TO convert(FROM value, QueryMapping.InternalColumn<FROM, TO> column) {
        Deserializer deserializer = (Deserializer)TypeMapping.getDeserializer(column).getOrElseThrow(() -> new IllegalStateException("Could not find serializer for " + column));
        try {
            return (TO)deserializer.apply(value);
        }
        catch (NullPointerException e) {
            if (value == null) {
                return null;
            }
            throw e;
        }
    }

    static void registerDefaults() {
        TypeMapping.register(Date.class, LocalDate.class, Date::toLocalDate);
        TypeMapping.register(Time.class, LocalTime.class, Time::toLocalTime);
        TypeMapping.register(Timestamp.class, LocalDateTime.class, Timestamp::toLocalDateTime);
        TypeMapping.register(Timestamp.class, ZonedDateTime.class, time -> time.toLocalDateTime().atZone(ZoneId.systemDefault()));
        TypeMapping.register(Integer.class, Boolean.class, value -> value == 1);
        TypeMapping.register(String.class, Boolean.class, str -> "J".equalsIgnoreCase((String)str) || "true".equalsIgnoreCase((String)str));
    }

    static {
        TypeMapping.registerDefaults();
    }

    public static interface Deserializer<FROM, TO>
    extends Function<FROM, TO> {
    }
}

