/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import no.nav.sbl.sql.SqlUtils;
import no.nav.sbl.sql.SqlUtilsException;
import no.nav.sbl.sql.Utils;
import no.nav.sbl.sql.where.WhereClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class UpsertQuery {
    private static final Logger log = LoggerFactory.getLogger(UpsertQuery.class);
    private final String upsertTemplate = "MERGE INTO %s USING dual ON (%s) WHEN MATCHED THEN %s WHEN NOT MATCHED THEN %s";
    private final JdbcTemplate db;
    private final String tableName;
    private final Map<String, Tuple2<ApplyTo, Object>> setParams;
    private WhereClause where;

    public UpsertQuery(JdbcTemplate db, String tableName) {
        this.db = db;
        this.tableName = tableName;
        this.setParams = new LinkedHashMap<String, Tuple2<ApplyTo, Object>>();
    }

    public UpsertQuery set(String param, Object value) {
        return this.set(param, value, ApplyTo.BOTH);
    }

    public UpsertQuery set(String param, Object value, ApplyTo applyTo) {
        if (this.setParams.containsKey(param)) {
            throw new IllegalArgumentException(String.format("Param[%s] was already set.", param));
        }
        this.setParams.put(param, (Tuple2<ApplyTo, Object>)Tuple.of((Object)((Object)applyTo), (Object)value));
        return this;
    }

    public UpsertQuery where(WhereClause where) {
        this.where = where;
        return this;
    }

    public Boolean execute() {
        if (this.tableName == null || this.where == null || this.setParams.isEmpty()) {
            throw new SqlUtilsException("I need more data to create a sql-statement. Did you remember to specify table name, what columns to set and a where clause?");
        }
        this.checkThatPrimarykeyAppliesToBoth();
        String upsertStatement = this.createUpsertStatement();
        return (Boolean)this.db.execute(upsertStatement, ps -> {
            int index = 1;
            for (Object obj : this.where.getArgs()) {
                ps.setObject(index++, obj);
            }
            for (Map.Entry entry : this.setParams.entrySet()) {
                if (this.where.appliesTo((String)entry.getKey()) || !this.skalSetParamVareMed(ApplyTo.UPDATE).test(entry)) continue;
                ps.setObject(index++, ((Tuple2)entry.getValue())._2());
            }
            for (Map.Entry entry : this.setParams.entrySet()) {
                if (!this.skalSetParamVareMed(ApplyTo.INSERT).test(entry)) continue;
                ps.setObject(index++, ((Tuple2)entry.getValue())._2());
            }
            log.debug(String.format("[UpsertQuery] Sql: %s \n [UpsertQuery] Params: %s", upsertStatement, this.setParams));
            Boolean result = Utils.timedPreparedStatement(upsertStatement, ps::execute);
            return result;
        });
    }

    private void checkThatPrimarykeyAppliesToBoth() {
        List<String> fields = this.where.getFields();
        boolean foundUpdateWhereClauseFields = fields.stream().map(field -> this.setParams.getOrDefault(field, (Tuple2<ApplyTo, Object>)Tuple.of((Object)((Object)ApplyTo.UPDATE), null))).anyMatch(fieldConfig -> ((ApplyTo)((Object)((Object)fieldConfig._1()))).equals((Object)ApplyTo.UPDATE));
        if (foundUpdateWhereClauseFields) {
            throw new SqlUtilsException("All fields mentioned in the where-clause must apply to the either `INSERT` or `BOTH`.");
        }
    }

    private String createUpsertStatement() {
        return String.format("MERGE INTO %s USING dual ON (%s) WHEN MATCHED THEN %s WHEN NOT MATCHED THEN %s", this.tableName, this.where.toSql(), this.createUpdateStatement(), this.createInsertStatement());
    }

    private String createUpdateStatement() {
        return String.format("UPDATE SET %s", this.createSetStatement());
    }

    private String createSetStatement() {
        String setStatement = this.setParams.entrySet().stream().filter(this.skalSetParamVareMed(ApplyTo.UPDATE)).map(Map.Entry::getKey).filter(key -> !this.where.appliesTo((String)key)).map(SqlUtils.append(" = ?")).collect(Collectors.joining(", "));
        if (setStatement.isEmpty()) {
            throw new SqlUtilsException("No fields set for update-statement. Fields present in the where-clause are automagically filtered out. Consider using `SqlUtils.insert`.");
        }
        return setStatement;
    }

    private Predicate<Map.Entry<String, Tuple2<ApplyTo, Object>>> skalSetParamVareMed(ApplyTo applyTo) {
        return entry -> ((ApplyTo)((Object)((Object)((Tuple2)entry.getValue())._1()))).appliesTo(applyTo);
    }

    private String createInsertStatement() {
        return String.format("INSERT (%s) VALUES (%s)", this.createInsertFields(), this.createInsertValues());
    }

    private String createInsertFields() {
        return this.setParams.entrySet().stream().filter(this.skalSetParamVareMed(ApplyTo.INSERT)).map(Map.Entry::getKey).collect(Collectors.joining(", "));
    }

    private String createInsertValues() {
        return this.setParams.entrySet().stream().filter(this.skalSetParamVareMed(ApplyTo.INSERT)).map(entry -> "?").collect(Collectors.joining(", "));
    }

    public String toString() {
        return this.createUpsertStatement();
    }

    public static enum ApplyTo {
        UPDATE(new ApplyTo[0]),
        INSERT(new ApplyTo[0]),
        BOTH(UPDATE, INSERT);

        public ApplyTo[] appliesTo;

        private ApplyTo(ApplyTo ... appliesTo) {
            this.appliesTo = appliesTo;
        }

        public boolean appliesTo(ApplyTo applyTo) {
            return this.equals((Object)applyTo) || Arrays.binarySearch((Object[])this.appliesTo, (Object)applyTo) >= 0;
        }
    }
}

