/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.metrics.prometheus.PrometheusMetricsTrackerFactory;

public class DataSourceFactory {
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = 150;
    private static final int DEFAULT_MINIMUM_IDLE = 1;

    private DataSourceFactory() {
    }

    public static Builder dataSource() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String username;
        private String password;
        private int maxPoolSize = 150;
        private int minimumIdle = 1;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder maxPoolSize(int poolSize) {
            this.maxPoolSize = poolSize;
            return this;
        }

        public Builder minimumIdle(int minimumIdle) {
            this.minimumIdle = minimumIdle;
            return this;
        }

        public HikariDataSource build() {
            this.checkStateValidity();
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(this.url);
            config.setUsername(this.username);
            config.setPassword(this.password);
            config.setMaximumPoolSize(this.maxPoolSize);
            config.setMinimumIdle(this.minimumIdle);
            config.setMetricsTrackerFactory((MetricsTrackerFactory)new PrometheusMetricsTrackerFactory());
            return new HikariDataSource(config);
        }

        private void checkStateValidity() {
            if (this.url == null) {
                throw new IllegalStateException("url ikke definert f\u00f8r kall p\u00e5 build()");
            }
            if (this.username == null) {
                throw new IllegalStateException("username ikke definert f\u00f8r kall p\u00e5 build()");
            }
            if (this.password == null) {
                throw new IllegalStateException("password ikke definert f\u00f8r kall p\u00e5 build()");
            }
        }
    }
}

