/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql;

import java.sql.ResultSet;
import java.util.function.Function;
import no.nav.sbl.sql.DeleteQuery;
import no.nav.sbl.sql.InsertQuery;
import no.nav.sbl.sql.SQLFunction;
import no.nav.sbl.sql.SelectQuery;
import no.nav.sbl.sql.UpdateBatchQuery;
import no.nav.sbl.sql.UpdateQuery;
import no.nav.sbl.sql.UpsertQuery;
import no.nav.sbl.sql.mapping.QueryMapping;
import no.nav.sbl.sql.mapping.SqlRecord;
import org.springframework.jdbc.core.JdbcTemplate;

public class SqlUtils {
    static Function<String, String> append(String suffix) {
        return value -> value + suffix;
    }

    public static UpdateQuery update(JdbcTemplate db, String tableName) {
        return new UpdateQuery(db, tableName);
    }

    public static <S> UpdateBatchQuery<S> updateBatch(JdbcTemplate db, String tableName, Class<S> cls) {
        return new UpdateBatchQuery(db, tableName);
    }

    public static InsertQuery insert(JdbcTemplate db, String tableName) {
        return new InsertQuery(db, tableName);
    }

    public static UpsertQuery upsert(JdbcTemplate db, String tableName) {
        return new UpsertQuery(db, tableName);
    }

    public static <T> SelectQuery<T> select(JdbcTemplate db, String tableName, SQLFunction<ResultSet, T> mapper) {
        return new SelectQuery<T>(db, tableName, mapper);
    }

    public static <T extends SqlRecord> SelectQuery<T> select(JdbcTemplate db, String tableName, Class<T> recordClass) {
        QueryMapping<SqlRecord> querymapping = QueryMapping.of(recordClass);
        SelectQuery<SqlRecord> selectQuery = new SelectQuery<SqlRecord>(db, tableName, querymapping::createMapper);
        querymapping.applyColumn(selectQuery);
        return selectQuery;
    }

    public static SelectQuery<Long> nextFromSeq(JdbcTemplate db, String sekvens) {
        return SqlUtils.select(db, "dual", (ResultSet resultSet) -> resultSet.getLong(1)).column(String.format("%s.NEXTVAL", sekvens));
    }

    public static DeleteQuery delete(JdbcTemplate db, String tableName) {
        return new DeleteQuery(db, tableName);
    }
}

