/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import no.nav.metrics.MetricsFactory;
import no.nav.metrics.Timer;

public class Utils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T timedPreparedStatement(String sql, Callable<T> task, Consumer<Timer> additions) {
        Timer timer = MetricsFactory.createTimer((String)Utils.dbTimerNavn(sql));
        try {
            timer.start();
            T t = task.call();
            return t;
        }
        catch (Throwable e) {
            timer.setFailed();
            throw e;
        }
        finally {
            timer.stop();
            if (additions != null) {
                additions.accept(timer);
            }
            timer.report();
        }
    }

    public static <T> T timedPreparedStatement(String name, Callable<T> task) {
        return Utils.timedPreparedStatement(name, task, null);
    }

    private static String dbTimerNavn(String sql) {
        return (sql + ".db").replaceAll("[^\\w]", "-");
    }
}

