/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql.where;

import java.util.Collection;
import java.util.List;
import no.nav.sbl.sql.where.ComparativeWhereClause;
import no.nav.sbl.sql.where.LogicalWhereClause;
import no.nav.sbl.sql.where.WhereIn;
import no.nav.sbl.sql.where.WhereIsNotNull;
import no.nav.sbl.sql.where.WhereIsNull;
import no.nav.sbl.sql.where.WhereOperator;

public abstract class WhereClause {
    public static WhereClause equals(String field, Object value) {
        return new ComparativeWhereClause(WhereOperator.EQUALS, field, value);
    }

    public static WhereClause gt(String field, Object value) {
        return new ComparativeWhereClause(WhereOperator.GT, field, value);
    }

    public static WhereClause gteq(String field, Object value) {
        return new ComparativeWhereClause(WhereOperator.GTEQ, field, value);
    }

    public static WhereClause lt(String field, Object value) {
        return new ComparativeWhereClause(WhereOperator.LT, field, value);
    }

    public static WhereClause lteq(String field, Object value) {
        return new ComparativeWhereClause(WhereOperator.LTEQ, field, value);
    }

    public static WhereClause in(String field, Collection<?> objects) {
        return WhereIn.of(field, objects);
    }

    public static WhereClause isNotNull(String field) {
        return WhereIsNotNull.of(field);
    }

    public static WhereClause isNull(String field) {
        return WhereIsNull.of(field);
    }

    public WhereClause and(WhereClause other) {
        return new LogicalWhereClause(WhereOperator.AND, this, other);
    }

    public WhereClause andIf(WhereClause other, boolean add) {
        return add ? this.and(other) : this;
    }

    public WhereClause or(WhereClause other) {
        return new LogicalWhereClause(WhereOperator.OR, this, other);
    }

    public abstract Object[] getArgs();

    public abstract String toSql();

    public abstract boolean appliesTo(String var1);

    public abstract List<String> getFields();
}

