/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql;

import io.vavr.Tuple;
import io.vavr.Tuple3;
import io.vavr.control.Option;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import no.nav.sbl.sql.SqlUtilsException;
import no.nav.sbl.sql.Utils;
import no.nav.sbl.sql.order.OrderClause;
import no.nav.sbl.sql.where.WhereClause;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class SelectQuery<T> {
    private JdbcTemplate db;
    private String tableName;
    private List<String> columnNames;
    private Function<ResultSet, T> mapper;
    private WhereClause where;
    private OrderClause order;
    private String groupBy;
    private Integer offset;
    private Integer rowCount;
    private Tuple3<String, String, String> leftJoinOn;

    SelectQuery(JdbcTemplate db, String tableName, Function<ResultSet, T> mapper) {
        this.db = db;
        this.tableName = tableName;
        this.columnNames = new ArrayList<String>();
        this.mapper = mapper;
    }

    public SelectQuery<T> leftJoinOn(String joinTableName, String leftOn, String rightOn) {
        this.leftJoinOn = Tuple.of((Object)joinTableName, (Object)leftOn, (Object)rightOn);
        return this;
    }

    public SelectQuery<T> column(String columnName) {
        this.columnNames.add(columnName);
        return this;
    }

    public SelectQuery<T> where(WhereClause where) {
        this.where = where;
        return this;
    }

    public SelectQuery<T> groupBy(String column) {
        this.groupBy = column;
        return this;
    }

    public SelectQuery<T> orderBy(OrderClause order) {
        this.order = order;
        return this;
    }

    public SelectQuery<T> limit(int offset, int rowCount) {
        this.offset = offset;
        this.rowCount = rowCount;
        return this;
    }

    public SelectQuery<T> limit(int rowCount) {
        return this.limit(0, rowCount);
    }

    public T execute() {
        this.validate();
        String sql = this.createSelectStatement();
        Object[] args = (Object[])Option.of((Object)this.where).map(WhereClause::getArgs).getOrElse((Object)new Object[0]);
        RowMapper mapper = (rs, rowNum) -> this.mapper.apply(rs);
        return (T)Utils.timedPreparedStatement(sql, () -> {
            List result = this.db.query(sql, args, mapper);
            if (result.isEmpty()) {
                return null;
            }
            return result.get(0);
        });
    }

    public List<T> executeToList() {
        this.validate();
        String sql = this.createSelectStatement();
        Object[] args = (Object[])Option.of((Object)this.where).map(WhereClause::getArgs).getOrElse((Object)new Object[0]);
        RowMapper mapper = (rs, rowNum) -> this.mapper.apply(rs);
        return Utils.timedPreparedStatement(sql, () -> this.db.query(sql, args, mapper));
    }

    private void validate() {
        if (this.tableName == null || this.columnNames.isEmpty()) {
            throw new SqlUtilsException("I need more data to create a sql-statement. Did you remember to specify table and columns?");
        }
        if (this.groupBy != null && !this.columnNames.contains(this.groupBy)) {
            throw new SqlUtilsException("You have to select the column which you are grouping by.");
        }
        if (this.mapper == null) {
            throw new SqlUtilsException("I need a mapper function in order to return the right data type.");
        }
    }

    private String createSelectStatement() {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT ");
        this.columnNames.stream().flatMap(x -> Stream.of(", ", x)).skip(1L).forEach(sqlBuilder::append);
        sqlBuilder.append(" ").append("FROM ").append(this.tableName);
        if (Objects.nonNull(this.leftJoinOn)) {
            sqlBuilder.append(String.format(" LEFT JOIN %s ON %s.%s = %s.%s", this.leftJoinOn._1, this.tableName, this.leftJoinOn._2, this.leftJoinOn._1, this.leftJoinOn._3));
        }
        if (this.where != null) {
            sqlBuilder.append(" WHERE ");
            sqlBuilder.append(this.where.toSql());
        }
        if (this.groupBy != null) {
            sqlBuilder.append(" GROUP BY ").append(this.groupBy);
        }
        if (this.order != null) {
            sqlBuilder.append(this.order.toSql());
        }
        if (this.offset != null) {
            sqlBuilder.append(String.format(" OFFSET %d ROWS FETCH NEXT %d ROWS ONLY", this.offset, this.rowCount));
        }
        return sqlBuilder.toString();
    }

    public String toString() {
        return this.createSelectStatement();
    }
}

