/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql;

import io.vavr.Tuple2;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import no.nav.sbl.sql.DbConstants;
import no.nav.sbl.sql.Utils;
import no.nav.sbl.sql.value.FunctionValue;
import no.nav.sbl.sql.value.Value;
import no.nav.sbl.sql.where.WhereClause;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

public class UpdateBatchQuery<T> {
    private final JdbcTemplate db;
    private final String tableName;
    private final Map<String, Value> setParams;
    private Function<T, WhereClause> whereClause;

    public UpdateBatchQuery(JdbcTemplate db, String tableName) {
        this.db = db;
        this.tableName = tableName;
        this.setParams = new LinkedHashMap<String, Value>();
    }

    public UpdateBatchQuery<T> add(String param, Function<T, Object> paramValue, Class type) {
        return this.add(param, new FunctionValue<T>(type, paramValue));
    }

    public UpdateBatchQuery<T> add(String param, DbConstants value) {
        return this.add(param, Value.of(value));
    }

    public UpdateBatchQuery<T> add(String param, Value value) {
        if (this.setParams.containsKey(param)) {
            throw new IllegalArgumentException(String.format("Param[%s] was already set.", param));
        }
        this.setParams.put(param, value);
        return this;
    }

    public UpdateBatchQuery<T> addWhereClause(Function<T, WhereClause> whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public int[] execute(final List<T> data) {
        if (data.isEmpty()) {
            return null;
        }
        String sql = this.createSql(data.get(0));
        return Utils.timedPreparedStatement(sql, () -> this.db.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object t = data.get(i);
                int j = 1;
                for (Value param : UpdateBatchQuery.this.setParams.values()) {
                    if (!(param instanceof FunctionValue)) continue;
                    FunctionValue functionValue = (FunctionValue)param;
                    Tuple2 config = (Tuple2)functionValue.getSql();
                    UpdateBatchQuery.setParam(ps, j++, (Class)config._1(), ((Function)config._2).apply(t));
                }
                if (Objects.nonNull(UpdateBatchQuery.this.whereClause)) {
                    for (Object obj : ((WhereClause)UpdateBatchQuery.this.whereClause.apply(t)).getArgs()) {
                        ps.setObject(j++, obj);
                    }
                }
            }

            public int getBatchSize() {
                return data.size();
            }
        }));
    }

    static void setParam(PreparedStatement ps, int i, Class type, Object value) throws SQLException {
        if (String.class == type) {
            ps.setString(i, (String)value);
        } else if (Timestamp.class == type) {
            ps.setTimestamp(i, (Timestamp)value);
        } else if (Integer.class == type) {
            if (value != null) {
                ps.setInt(i, (Integer)value);
            } else {
                ps.setInt(i, -1);
            }
        } else if (Boolean.class == type) {
            ps.setBoolean(i, (Boolean)value);
        }
    }

    String createSql(T t) {
        StringBuilder sqlBuilder = new StringBuilder().append("update ").append(this.tableName).append(this.createSetStatement());
        if (Objects.nonNull(this.whereClause)) {
            sqlBuilder.append(" where ").append(this.whereClause.apply(t).toSql());
        }
        return sqlBuilder.toString();
    }

    private String createSetStatement() {
        return " set " + this.setParams.entrySet().stream().map(entry -> (String)entry.getKey() + " = " + ((Value)entry.getValue()).getValuePlaceholder()).collect(Collectors.joining(", "));
    }
}

