/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql.mapping;

import io.vavr.CheckedFunction0;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.Arrays;
import no.nav.sbl.sql.SelectQuery;
import no.nav.sbl.sql.mapping.SqlRecord;
import no.nav.sbl.sql.mapping.TypeMapping;
import no.nav.sbl.sql.mapping.ValueMapping;

public class QueryMapping<T extends SqlRecord> {
    private static List<String> ignoreFields = List.of((Object)"$jacocoData");
    private static Map<Class<? extends SqlRecord>, QueryMapping<? extends SqlRecord>> mappers = HashMap.empty();
    private Class<T> targetClass;
    private List<InternalColumn> columns;
    private Constructor<T> constructor;

    private QueryMapping(Class<T> targetClass) {
        this.targetClass = targetClass;
        this.columns = this.getColumns();
        this.constructor = this.getConstructor();
    }

    public static <T extends SqlRecord> QueryMapping<T> of(Class<T> targetClass) {
        if (!mappers.containsKey(targetClass)) {
            mappers = mappers.put(targetClass, new QueryMapping<T>(targetClass));
        }
        return (QueryMapping)mappers.get(targetClass).getOrNull();
    }

    public SelectQuery<T> applyColumn(SelectQuery<T> query) {
        this.columns.forEach(column -> query.column(column.name));
        return query;
    }

    public T createMapper(ResultSet rs) {
        return (T)((SqlRecord)Try.of((CheckedFunction0 & Serializable)() -> {
            Object[] parameters = this.columns.map(column -> this.deserialize((InternalColumn)column, rs)).toJavaArray();
            return (SqlRecord)this.constructor.newInstance(parameters);
        }).getOrElseThrow(err -> new RuntimeException("Failed to deserialize", (Throwable)err)));
    }

    public static <FROM, TO> void register(Class<FROM> fromCls, Class<TO> toCls, TypeMapping.Deserializer<FROM, TO> deserializer) {
        TypeMapping.register(fromCls, toCls, deserializer);
    }

    private <FROM, TO> Column<FROM, TO> deserialize(InternalColumn<FROM, TO> column, ResultSet rs) {
        FROM value = ValueMapping.getValue(column, rs);
        return Column.of(TypeMapping.convert(value, column));
    }

    private List<InternalColumn> getColumns() {
        List fields = List.of((Object[])this.targetClass.getDeclaredFields()).filter(field -> !ignoreFields.contains((Object)field.getName()));
        QueryMapping.verifyAllFieldsAreColumns((List<Field>)fields);
        List columns = fields.map(field -> {
            String name = field.getName();
            Type[] genericTypes = ((ParameterizedType)field.getAnnotatedType().getType()).getActualTypeArguments();
            Class from = (Class)genericTypes[0];
            Class to = (Class)genericTypes[1];
            return new InternalColumn(name, from, to);
        });
        QueryMapping.verifyAllMappingAreDefined((List<InternalColumn>)columns);
        return columns;
    }

    private Constructor<T> getConstructor() {
        InternalColumn[] parameterTypes = (InternalColumn[])this.columns.toJavaArray(InternalColumn.class);
        Constructor<T> constructor = QueryMapping.findConstructorWithParamLength(this.targetClass, parameterTypes.length);
        QueryMapping.verifyConstructorParameters(constructor, parameterTypes);
        return constructor;
    }

    private static void verifyAllFieldsAreColumns(List<Field> fields) {
        Option brokenField = fields.find(field -> !Column.class.isAssignableFrom(field.getType()));
        if (brokenField.isDefined()) {
            throw new IllegalArgumentException("targetClass contains non-column fields " + brokenField);
        }
    }

    private static void verifyAllMappingAreDefined(List<InternalColumn> columns) {
        boolean allDefined = columns.map(TypeMapping::getDeserializer).forAll(Option::isDefined);
        if (!allDefined) {
            throw new IllegalArgumentException("targetClass contains column without known mapping: " + columns);
        }
    }

    private static <T> Constructor<T> findConstructorWithParamLength(Class<T> targetClass, int targetLength) {
        List constructors = List.of((Object[])targetClass.getConstructors()).filter(constructor -> constructor.getParameterCount() == targetLength);
        if (constructors.length() != 1) {
            throw new IllegalArgumentException("Found " + constructors.length() + " constructors with " + targetLength + "parameters. Expected just one.");
        }
        return (Constructor)constructors.get(0);
    }

    private static <T> void verifyConstructorParameters(Constructor<T> constructor, InternalColumn[] parameterTypes) {
        List constructorTypes = List.of((Object[])constructor.getGenericParameterTypes());
        QueryMapping.verifyParameterBaseType((List<Type>)constructorTypes, parameterTypes);
        QueryMapping.verifyParameterGenericType((List<Type>)constructorTypes, parameterTypes);
    }

    private static void verifyParameterBaseType(List<Type> constructorTypes, InternalColumn[] parameterTypes) {
        int nonGenericConstructorTypes = constructorTypes.filter(cls -> !(cls instanceof ParameterizedType)).length();
        if (nonGenericConstructorTypes > 0) {
            String msg = "Constructor parameter mismatch, expected " + Arrays.toString(parameterTypes) + " found: " + constructorTypes;
            throw new IllegalArgumentException(msg);
        }
    }

    private static void verifyParameterGenericType(List<Type> constructorTypes, InternalColumn[] parameterTypes) {
        List constructorGenericTypes = constructorTypes.map(param -> {
            Type[] genericTypes = ((ParameterizedType)param).getActualTypeArguments();
            Class from = (Class)genericTypes[0];
            Class to = (Class)genericTypes[1];
            return Tuple.of((Object)from, (Object)to);
        });
        for (int i = 0; i < parameterTypes.length; ++i) {
            InternalColumn paramType = parameterTypes[i];
            Tuple2 constructorType = (Tuple2)constructorGenericTypes.get(i);
            if (paramType.from.equals(constructorType._1) && paramType.to.equals(constructorType._2)) continue;
            String msg = "Constructor parameter mismatch, expected " + Arrays.toString(parameterTypes) + " found: " + constructorTypes;
            throw new IllegalArgumentException(msg);
        }
    }

    public static final class Column<FROM, TO> {
        public final TO value;

        @ConstructorProperties(value={"value"})
        private Column(TO value) {
            this.value = value;
        }

        public static <FROM, TO> Column<FROM, TO> of(TO value) {
            return new Column<FROM, TO>(value);
        }

        public TO getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column other = (Column)o;
            TO this$value = this.getValue();
            TO other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TO $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "QueryMapping.Column(value=" + this.getValue() + ")";
        }
    }

    static final class InternalColumn<FROM, TO> {
        public final String name;
        public final Class<FROM> from;
        public final Class<TO> to;

        @ConstructorProperties(value={"name", "from", "to"})
        private InternalColumn(String name, Class<FROM> from, Class<TO> to) {
            this.name = name;
            this.from = from;
            this.to = to;
        }

        public static <FROM, TO> InternalColumn<FROM, TO> of(String name, Class<FROM> from, Class<TO> to) {
            return new InternalColumn<FROM, TO>(name, from, to);
        }

        public String getName() {
            return this.name;
        }

        public Class<FROM> getFrom() {
            return this.from;
        }

        public Class<TO> getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InternalColumn)) {
                return false;
            }
            InternalColumn other = (InternalColumn)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<FROM> this$from = this.getFrom();
            Class<FROM> other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            Class<TO> this$to = this.getTo();
            Class<TO> other$to = other.getTo();
            return !(this$to == null ? other$to != null : !this$to.equals(other$to));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<FROM> $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            Class<TO> $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            return result;
        }

        public String toString() {
            return "QueryMapping.InternalColumn(name=" + this.getName() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }
    }
}

