/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import no.nav.sbl.sql.DbConstants;
import no.nav.sbl.sql.Utils;
import no.nav.sbl.sql.value.Value;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class InsertQuery {
    private final JdbcTemplate db;
    private final String tableName;
    private final Map<String, Value> insertParams;

    public InsertQuery(JdbcTemplate db, String tableName) {
        this.db = db;
        this.tableName = tableName;
        this.insertParams = new LinkedHashMap<String, Value>();
    }

    public InsertQuery value(String columnName, Value value) {
        this.insertParams.put(columnName, value);
        return this;
    }

    public InsertQuery value(String columnName, DbConstants value) {
        return this.value(columnName, Value.of(value));
    }

    public InsertQuery value(String columnName, Object value) {
        return this.value(columnName, Value.of(value));
    }

    public int execute() {
        String sql = this.createSqlStatement();
        Object[] args = this.insertParams.values().stream().filter(Value::hasPlaceholder).map(Value::getSql).collect(Collectors.toList()).toArray();
        return Utils.timedPreparedStatement(sql, () -> this.db.update(sql, args));
    }

    private String createSqlStatement() {
        String columns = StringUtils.join(this.insertParams.keySet(), (String)",");
        String values = this.insertParams.values().stream().map(Value::getValuePlaceholder).collect(Collectors.joining(","));
        return String.format("insert into %s (%s) values (%s)", this.tableName, columns, values);
    }

    public String toString() {
        return this.createSqlStatement();
    }
}

