/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql;

import io.vavr.Tuple2;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import no.nav.sbl.sql.DbConstants;
import no.nav.sbl.sql.Utils;
import no.nav.sbl.sql.value.FunctionValue;
import no.nav.sbl.sql.value.Value;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

public class InsertBatchQuery<T> {
    private final JdbcTemplate db;
    private final String tableName;
    private final Map<String, Value> values;

    public InsertBatchQuery(JdbcTemplate db, String tableName) {
        this.db = db;
        this.tableName = tableName;
        this.values = new LinkedHashMap<String, Value>();
    }

    public InsertBatchQuery<T> add(String param, Function<T, Object> paramValue, Class type) {
        return this.add(param, new FunctionValue<T>(type, paramValue));
    }

    public InsertBatchQuery<T> add(String param, DbConstants value) {
        return this.add(param, Value.of(value));
    }

    public InsertBatchQuery<T> add(String param, Value value) {
        if (this.values.containsKey(param)) {
            throw new IllegalArgumentException(String.format("Param[%s] was already set.", param));
        }
        this.values.put(param, value);
        return this;
    }

    public int[] execute(final List<T> data) {
        if (data.isEmpty()) {
            return null;
        }
        String sql = this.createSqlStatement();
        return Utils.timedPreparedStatement(sql, () -> this.db.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object t = data.get(i);
                int j = 1;
                for (Value param : InsertBatchQuery.this.values.values()) {
                    if (!(param instanceof FunctionValue)) continue;
                    FunctionValue functionValue = (FunctionValue)param;
                    Tuple2 config = (Tuple2)functionValue.getSql();
                    InsertBatchQuery.setParam(ps, j++, (Class)config._1(), ((Function)config._2).apply(t));
                }
            }

            public int getBatchSize() {
                return data.size();
            }
        }));
    }

    static void setParam(PreparedStatement ps, int i, Class type, Object value) throws SQLException {
        if (String.class == type) {
            ps.setString(i, (String)value);
        } else if (Timestamp.class == type) {
            ps.setTimestamp(i, (Timestamp)value);
        } else if (Boolean.class == type) {
            ps.setBoolean(i, (Boolean)value);
        } else if (Integer.class == type) {
            ps.setInt(i, (Integer)value);
        }
    }

    private String createSqlStatement() {
        String columns = StringUtils.join(this.values.keySet(), (String)",");
        String valueParams = this.values.values().stream().map(Value::getValuePlaceholder).collect(Collectors.joining(","));
        return String.format("insert into %s (%s) values (%s)", this.tableName, columns, valueParams);
    }
}

