/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import no.nav.sbl.sql.DbConstants;
import no.nav.sbl.sql.Utils;
import no.nav.sbl.sql.value.Value;
import org.springframework.jdbc.core.JdbcTemplate;

public class UpdateQuery {
    private final JdbcTemplate db;
    private final String tableName;
    private final Map<String, Value> setParams;
    private String whereParam;
    private Object whereValue;

    public UpdateQuery(JdbcTemplate db, String tableName) {
        this.db = db;
        this.tableName = tableName;
        this.setParams = new LinkedHashMap<String, Value>();
    }

    public UpdateQuery set(String param, Object value) {
        return this.set(param, Value.of(value));
    }

    public UpdateQuery set(String param, DbConstants value) {
        return this.set(param, Value.of(value));
    }

    public UpdateQuery set(String param, Value value) {
        if (this.setParams.containsKey(param)) {
            throw new IllegalArgumentException(String.format("Param[%s] was already set.", param));
        }
        this.setParams.put(param, value);
        return this;
    }

    public UpdateQuery whereEquals(String whereParam, Object whereValue) {
        this.whereParam = whereParam;
        this.whereValue = whereValue;
        return this;
    }

    public Integer execute() {
        assert (this.tableName != null);
        assert (!this.setParams.isEmpty());
        StringBuilder sqlBuilder = new StringBuilder().append("update ").append(this.tableName).append(this.createSetStatement());
        if (this.whereParam != null) {
            sqlBuilder.append(" where ").append(this.whereParam).append(" = ?");
        }
        String sql = sqlBuilder.toString();
        return Utils.timedPreparedStatement(sql, () -> this.db.update(sql, this.createSqlArgumentArray()));
    }

    private Object[] createSqlArgumentArray() {
        List args = this.setParams.values().stream().filter(Value::hasPlaceholder).map(Value::getSql).collect(Collectors.toList());
        if (this.whereValue != null) {
            args.add(this.whereValue);
        }
        return args.toArray();
    }

    private String createSetStatement() {
        return " set " + this.setParams.entrySet().stream().map(entry -> (String)entry.getKey() + " = " + ((Value)entry.getValue()).getValuePlaceholder()).collect(Collectors.joining(", "));
    }
}

