/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql;

import no.nav.sbl.sql.SqlUtilsException;
import no.nav.sbl.sql.Utils;
import no.nav.sbl.sql.where.WhereClause;
import org.springframework.jdbc.core.JdbcTemplate;

public class DeleteQuery {
    private final JdbcTemplate db;
    private final String tableName;
    private WhereClause where;

    DeleteQuery(JdbcTemplate db, String tableName) {
        this.db = db;
        this.tableName = tableName;
    }

    public DeleteQuery where(WhereClause where) {
        this.where = where;
        return this;
    }

    public int execute() {
        if (this.tableName == null || this.where == null) {
            throw new SqlUtilsException("I need more data to create a sql-statement. Did you remember to specify table and a where clause?");
        }
        String sql = this.createDeleteStatement();
        return Utils.timedPreparedStatement(sql, () -> this.db.update(sql, this.where.getArgs()));
    }

    private String createDeleteStatement() {
        return String.format("DELETE FROM %s WHERE %s", this.tableName, this.where.toSql());
    }

    public String toString() {
        return this.createDeleteStatement();
    }
}

