/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.sql.where;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import no.nav.sbl.sql.where.WhereClause;
import no.nav.sbl.sql.where.WhereOperator;

public class WhereIn
extends WhereClause {
    private String field;
    private Collection<? extends Object> objects;

    WhereIn(String field, Collection<? extends Object> objects) {
        this.field = field;
        this.objects = objects;
    }

    static WhereIn of(String field, Collection<? extends Object> objects) {
        return new WhereIn(field, objects);
    }

    @Override
    public Object[] getArgs() {
        return this.objects.toArray();
    }

    @Override
    public String toSql() {
        String parameters = this.objects.stream().map(dummy -> "?").collect(Collectors.joining(","));
        return String.format("%s %s (%s)", this.field, WhereOperator.IN.sql, parameters);
    }

    @Override
    public boolean appliesTo(String key) {
        return key.equals(this.field);
    }

    @Override
    public List<String> getFields() {
        return Collections.singletonList(this.field);
    }
}

