/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import no.nav.metrics.MetodeTimer;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class Database {
    private final JdbcTemplate jdbcTemplate;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public Database(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
    }

    public <T> List<T> query(String sql, Mapper<T> mapper, Object ... args) {
        return this.time(sql, () -> this.jdbcTemplate.query(sql, (RowMapper)mapper, args));
    }

    public int update(String sql, Object ... args) {
        return this.time(sql, () -> this.jdbcTemplate.update(sql, args));
    }

    public <T> T queryForObject(String sql, Mapper<T> mapper, Object ... args) {
        return (T)this.time(sql, () -> this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, args));
    }

    public <T> List<T> queryWithNamedParam(String sql, Mapper<T> mapper, Map<String, Object> map) {
        return this.time(sql, () -> this.namedParameterJdbcTemplate.query(sql, map, (RowMapper)mapper));
    }

    public long nesteFraSekvens(String sekvensNavn) {
        return (Long)this.jdbcTemplate.queryForObject("select " + sekvensNavn + ".nextval from dual", Long.class);
    }

    public static Date hentDato(ResultSet rs, String kolonneNavn) throws SQLException {
        return Optional.ofNullable(rs.getTimestamp(kolonneNavn)).map(Timestamp::getTime).map(Date::new).orElse(null);
    }

    private <T> T time(String sql, Callable<T> callable) {
        return (T)MetodeTimer.timeMetode(callable::call, (String)this.timerNavn(sql));
    }

    private String timerNavn(String sql) {
        return (sql + ".db").replaceAll("[^\\w]", "-");
    }

    @FunctionalInterface
    public static interface Mapper<T>
    extends RowMapper<T> {
        public T map(ResultSet var1) throws SQLException;

        default public T mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            return this.map(resultSet);
        }
    }
}

