/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.job;

import java.util.concurrent.CompletableFuture;
import no.nav.common.utils.IdUtils;
import no.nav.common.utils.fn.UnsafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class JobRunner {
    private static final Logger log = LoggerFactory.getLogger(JobRunner.class);

    public static String run(UnsafeRunnable runnable) {
        String jobId = IdUtils.generateId();
        JobRunner.run(jobId, jobId, runnable);
        return jobId;
    }

    public static String run(String jobName, UnsafeRunnable runnable) {
        String jobId = IdUtils.generateId();
        JobRunner.run(jobName, jobId, runnable);
        return jobId;
    }

    public static void run(String jobName, String jobId, UnsafeRunnable runnable) {
        try {
            MDC.put((String)"jobId", (String)jobId);
            MDC.put((String)"jobName", (String)jobName);
            log.info("Job started. jobName={} jobId={}", (Object)jobName, (Object)jobId);
            runnable.run();
            log.info("Job finished. jobName={} jobId={}", (Object)jobName, (Object)jobId);
        }
        catch (Exception e) {
            log.error(String.format("Job failed. jobName=%s jobId=%s", jobName, jobId), (Throwable)e);
            throw e;
        }
        finally {
            MDC.remove((String)"jobId");
            MDC.remove((String)"jobName");
        }
    }

    public static String runAsync(UnsafeRunnable runnable) {
        String jobId = IdUtils.generateId();
        JobRunner.runAsync(jobId, jobId, runnable);
        return jobId;
    }

    public static String runAsync(String jobName, UnsafeRunnable runnable) {
        String jobId = IdUtils.generateId();
        JobRunner.runAsync(jobName, jobId, runnable);
        return jobId;
    }

    public static void runAsync(String jobName, String jobId, UnsafeRunnable runnable) {
        CompletableFuture.runAsync(() -> JobRunner.run(jobName, jobId, runnable));
    }
}

