/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.job.leader_election;

import java.net.InetAddress;
import no.nav.common.job.leader_election.LeaderElectionClient;
import no.nav.common.job.leader_election.LeaderResponse;
import no.nav.common.json.JsonUtils;
import no.nav.common.utils.EnvironmentUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectionHttpClient
implements LeaderElectionClient {
    private static final Logger log = LoggerFactory.getLogger(LeaderElectionHttpClient.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderElectionHttpClient.class);
    private final OkHttpClient client = new OkHttpClient();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isLeader() {
        String electorPath = EnvironmentUtils.getRequiredProperty((String)"ELECTOR_PATH", (String[])new String[0]);
        Request request = new Request.Builder().url("http://" + electorPath).get().build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                LOGGER.error(String.format("Received unexpected status from leader election sidecar %d:%s", response.code(), response.message()));
                boolean bl = false;
                return bl;
            }
            LeaderResponse leader = (LeaderResponse)JsonUtils.fromJson((String)response.body().string(), LeaderResponse.class);
            boolean bl = InetAddress.getLocalHost().getHostName().equals(leader.getName());
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Failed to check if pod is leader", (Throwable)e);
            return false;
        }
    }
}

