/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.job.leader_election;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import no.nav.common.job.leader_election.LeaderElectionClient;
import no.nav.common.utils.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShedLockLeaderElectionClient
implements LeaderElectionClient {
    private static final Logger log = LoggerFactory.getLogger(ShedLockLeaderElectionClient.class);
    private static final String LOCK_NAME = "leader-election";
    private static final Duration LOCK_AT_MOST_FOR = Duration.ofMinutes(10L);
    private static final Duration LOCK_AT_LEAST_FOR = Duration.ofSeconds(10L);
    private static final long CHECK_LOCK_INTERVAL_IN_SECONDS = 60L;
    private static final int CLOCK_SKEW_SECONDS = 5;
    private static final int EXPIRATION_THRESHOLD_SECONDS = 180;
    private final LockProvider lockProvider;
    private final ScheduledExecutorService scheduler;
    private final String hostname;
    private volatile boolean hasShutDown;
    private volatile Instant lockExpiration;
    private volatile SimpleLock lock;

    public ShedLockLeaderElectionClient(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.hostname = EnvironmentUtils.resolveHostName();
        this.scheduler.scheduleWithFixedDelay(this::keepLockAlive, 0L, 60L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdownHook));
    }

    @Override
    public boolean isLeader() {
        return this.hasAcquiredLock();
    }

    private void keepLockAlive() {
        if (this.hasAcquiredLock()) {
            this.extendLockIfAboutToExpire();
        } else {
            this.tryToAcquireLock();
        }
    }

    private void extendLockIfAboutToExpire() {
        Instant lockAboutToExpire;
        Instant now = Instant.now();
        if (now.isAfter(lockAboutToExpire = this.lockExpiration.minusSeconds(180L))) {
            log.info("Extending lock which is about to expire. ExtendLockThreshold={} LockExpiresAt={}", (Object)lockAboutToExpire, (Object)this.lockExpiration);
            try {
                Optional maybeLock = this.lock.extend(LOCK_AT_MOST_FOR, LOCK_AT_LEAST_FOR);
                if (maybeLock.isPresent()) {
                    this.setupNewLock((SimpleLock)maybeLock.get(), now);
                    log.info("Lock was extended. {} is still the leader", (Object)this.hostname);
                } else {
                    log.warn("Unable to extend lock");
                }
            }
            catch (UnsupportedOperationException uoe) {
                log.error("ShedLock leader election is being used with a lock provider that does not support lock extension", (Throwable)uoe);
            }
            catch (Exception e) {
                log.error("Caught exception when extending leader election lock", (Throwable)e);
            }
        }
    }

    private void tryToAcquireLock() {
        Instant createdAt = Instant.now();
        LockConfiguration config = new LockConfiguration(createdAt, LOCK_NAME, LOCK_AT_MOST_FOR, LOCK_AT_LEAST_FOR);
        this.lockProvider.lock(config).ifPresent(lock -> {
            this.setupNewLock((SimpleLock)lock, createdAt);
            log.info("Acquired leader election lock. {} is now the leader", (Object)this.hostname);
        });
    }

    private void setupNewLock(SimpleLock newLock, Instant createdAt) {
        this.lock = newLock;
        this.lockExpiration = createdAt.plusMillis(LOCK_AT_MOST_FOR.toMillis());
    }

    private boolean hasAcquiredLock() {
        if (this.hasShutDown || this.lockExpiration == null) {
            return false;
        }
        Instant currentTimeWithSkew = Instant.now().plusSeconds(5L);
        return currentTimeWithSkew.isBefore(this.lockExpiration);
    }

    private void shutdownHook() {
        log.info("Shutting down ShedLock leader election client...");
        this.hasShutDown = true;
        this.scheduler.shutdown();
        if (this.lock != null) {
            try {
                this.lock.unlock();
                log.info("Leader election lock was released from {} due to shutting down", (Object)this.hostname);
            }
            catch (Exception e) {
                log.error("Caught exception when unlocking lock during shutdown hook", (Throwable)e);
            }
        }
    }
}

