/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.job;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import no.nav.common.job.JobRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class JobRunnerTest {
    private ListAppender<ILoggingEvent> jobAppender;
    private Logger jobLogger = (Logger)LoggerFactory.getLogger(JobRunner.class);

    @Before
    public void setUp() {
        this.jobAppender = new ListAppender();
        this.jobAppender.start();
        this.jobLogger.addAppender(this.jobAppender);
    }

    @After
    public void tearDown() {
        this.jobLogger.detachAppender(this.jobAppender);
    }

    @Test
    public void should_log_job_start_and_end() {
        JobRunner.run((String)"test", (String)"id", () -> {});
        Assert.assertEquals((long)2L, (long)this.jobAppender.list.size());
        Assert.assertEquals((Object)"Job started. jobName=test jobId=id", (Object)((ILoggingEvent)this.jobAppender.list.get(0)).getFormattedMessage());
        Assert.assertEquals((Object)"Job finished. jobName=test jobId=id", (Object)((ILoggingEvent)this.jobAppender.list.get(1)).getFormattedMessage());
    }

    @Test
    public void should_log_job_start_and_failure() {
        try {
            JobRunner.run((String)"test", (String)"id", () -> {
                throw new RuntimeException();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)this.jobAppender.list.size());
        Assert.assertEquals((Object)"Job started. jobName=test jobId=id", (Object)((ILoggingEvent)this.jobAppender.list.get(0)).getFormattedMessage());
        Assert.assertEquals((Object)"Job failed. jobName=test jobId=id", (Object)((ILoggingEvent)this.jobAppender.list.get(1)).getMessage());
    }

    @Test
    public void should_add_mdc_properties() {
        JobRunner.run((String)"test", (String)"id", () -> {
            Logger testLogger = (Logger)LoggerFactory.getLogger(JobRunnerTest.class);
            ListAppender testAppender = new ListAppender();
            testAppender.start();
            testLogger.addAppender((Appender)testAppender);
            testLogger.info("test");
            Assert.assertEquals((Object)"{jobName=test, jobId=id}", (Object)((ILoggingEvent)testAppender.list.get(0)).getMDCPropertyMap().toString());
        });
    }
}

