/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.job.leader_election;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.net.InetAddress;
import java.net.UnknownHostException;
import no.nav.common.job.leader_election.LeaderElectionHttpClient;
import no.nav.common.test.junit.SystemPropertiesRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LeaderElectionHttpClientTest {
    @Rule
    public WireMockRule wireMockRule = new WireMockRule(0);
    @Rule
    public SystemPropertiesRule systemPropertiesRule = new SystemPropertiesRule();
    private String hostName;

    @Before
    public void setUp() throws UnknownHostException {
        this.systemPropertiesRule.setProperty("ELECTOR_PATH", "localhost:" + this.wireMockRule.port());
        this.hostName = InetAddress.getLocalHost().getHostName();
    }

    @Test
    public void isLeaderIsTrue() {
        this.isLeader(true);
        LeaderElectionHttpClient leaderElectionHttpClient = new LeaderElectionHttpClient();
        Assert.assertTrue((boolean)leaderElectionHttpClient.isLeader());
    }

    @Test
    public void isLeaderIsFalse() {
        this.isLeader(false);
        LeaderElectionHttpClient leaderElectionHttpClient = new LeaderElectionHttpClient();
        Assert.assertFalse((boolean)leaderElectionHttpClient.isLeader());
    }

    private void isLeader(boolean value) {
        String name = value ? this.hostName : "not leader";
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(200).withBody("{\"name\": \"" + name + "\"}")));
    }
}

