/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.job.leader_election;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.javacrumbs.shedlock.core.LockProvider;
import no.nav.common.job.leader_election.ShedLockLeaderElectionClient;
import org.junit.Assert;
import org.junit.Test;

public class ShedLockLeaderElectionClientTest {
    @Test
    public void should_acquire_lock_for_one_client_and_deny_the_other() throws InterruptedException {
        AtomicInteger counter = new AtomicInteger();
        LockProvider provider = lockConfiguration -> {
            if (counter.incrementAndGet() > 1) {
                return Optional.empty();
            }
            return Optional.of(() -> {});
        };
        ShedLockLeaderElectionClient client1 = new ShedLockLeaderElectionClient(provider);
        Thread.sleep(100L);
        ShedLockLeaderElectionClient client2 = new ShedLockLeaderElectionClient(provider);
        Thread.sleep(100L);
        Assert.assertTrue((boolean)client1.isLeader());
        Assert.assertFalse((boolean)client2.isLeader());
        Assert.assertTrue((boolean)client1.isLeader());
        Assert.assertFalse((boolean)client2.isLeader());
        Assert.assertEquals((long)2L, (long)counter.get());
    }
}

