/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.util;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import no.nav.common.kafka.consumer.ConsumeStatus;
import no.nav.common.kafka.consumer.util.TopicConsumerListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class TopicConsumerMetrics<K, V>
implements TopicConsumerListener<K, V> {
    public static final String KAFKA_CONSUMER_STATUS_COUNTER = "kafka.consumer.status";
    public static final String KAFKA_CONSUMER_CONSUMED_OFFSET_GAUGE = "kafka.consumer.consumed-offset";
    private final MeterRegistry meterRegistry;
    private final Map<String, Counter> statusCounterMap = new HashMap<String, Counter>();
    private final Map<String, Gauge> consumedOffsetGaugeMap = new HashMap<String, Gauge>();
    private final Map<String, Long> consumedOffsetMap = new HashMap<String, Long>();

    public TopicConsumerMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void onConsumed(ConsumerRecord<K, V> record, ConsumeStatus status) {
        String statusMapKey = String.format("%s-%d-%s", new Object[]{record.topic(), record.partition(), status});
        this.statusCounterMap.computeIfAbsent(statusMapKey, k -> Counter.builder((String)KAFKA_CONSUMER_STATUS_COUNTER).tag("topic", record.topic()).tag("partition", String.valueOf(record.partition())).tag("status", status.name().toLowerCase()).register(this.meterRegistry)).increment();
        if (status == ConsumeStatus.OK) {
            String offsetMapKey = String.format("%s-%d", record.topic(), record.partition());
            this.consumedOffsetMap.put(offsetMapKey, record.offset());
            this.consumedOffsetGaugeMap.computeIfAbsent(statusMapKey, k -> Gauge.builder((String)KAFKA_CONSUMER_CONSUMED_OFFSET_GAUGE, () -> {
                Long offset = this.consumedOffsetMap.get(offsetMapKey);
                return offset != null ? offset : 0L;
            }).description("The latest consumed offset. The offset is not guaranteed to have been committed.").tag("topic", record.topic()).tag("partition", String.valueOf(record.partition())).register(this.meterRegistry));
        }
    }
}

