/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.feilhandtering;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.List;
import javax.sql.DataSource;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRepository;
import no.nav.common.kafka.consumer.feilhandtering.StoredConsumerRecord;
import no.nav.common.kafka.util.DatabaseUtils;
import org.apache.kafka.common.TopicPartition;

public class OracleConsumerRepository
implements KafkaConsumerRepository {
    private final DataSource dataSource;
    private final String consumerRecordTable;

    public OracleConsumerRepository(DataSource dataSource, String consumerRecordTable) {
        this.dataSource = dataSource;
        this.consumerRecordTable = consumerRecordTable;
    }

    public OracleConsumerRepository(DataSource dataSource) {
        this(dataSource, "KAFKA_CONSUMER_RECORD");
    }

    @Override
    public long storeRecord(StoredConsumerRecord record) {
        long l;
        block11: {
            String sql = String.format("INSERT INTO %s (%s, %s, %s, %s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", this.consumerRecordTable, "ID", "TOPIC", "PARTITION", "RECORD_OFFSET", "KEY", "VALUE", "HEADERS_JSON", "RECORD_TIMESTAMP");
            long id = DatabaseUtils.incrementAndGetOracleSequence(this.dataSource, "KAFKA_CONSUMER_RECORD_ID_SEQ");
            PreparedStatement statement = DatabaseUtils.createPreparedStatement(this.dataSource, sql);
            try {
                statement.setLong(1, id);
                statement.setString(2, record.getTopic());
                statement.setInt(3, record.getPartition());
                statement.setLong(4, record.getOffset());
                statement.setBytes(5, record.getKey());
                statement.setBytes(6, record.getValue());
                statement.setString(7, record.getHeadersJson());
                statement.setLong(8, record.getTimestamp());
                statement.executeUpdate();
                l = id;
                if (statement == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLIntegrityConstraintViolationException e) {
                    return -1L;
                }
            }
            statement.close();
        }
        return l;
    }

    @Override
    public void deleteRecords(List<Long> ids) {
        String sql = String.format("DELETE FROM %s WHERE %s = ANY(?)", this.consumerRecordTable, "ID");
        try (PreparedStatement statement = DatabaseUtils.createPreparedStatement(this.dataSource, sql);){
            Array array = this.dataSource.getConnection().createArrayOf("INTEGER", ids.toArray());
            statement.setArray(1, array);
            statement.executeUpdate();
        }
    }

    @Override
    public boolean hasRecordWithKey(String topic, int partition, byte[] key) {
        boolean bl;
        block8: {
            String sql = String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ? AND %s = ? FETCH NEXT 1 ROWS ONLY", "ID", this.consumerRecordTable, "TOPIC", "PARTITION", "KEY");
            PreparedStatement statement = DatabaseUtils.createPreparedStatement(this.dataSource, sql);
            try {
                statement.setString(1, topic);
                statement.setInt(2, partition);
                statement.setBytes(3, key);
                bl = statement.executeQuery().next();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            statement.close();
        }
        return bl;
    }

    @Override
    public List<StoredConsumerRecord> getRecords(String topic, int partition, int maxRecords) {
        List<StoredConsumerRecord> list;
        block8: {
            String sql = String.format("SELECT * FROM %s WHERE %s = ? AND %s = ? ORDER BY %s FETCH NEXT %d ROWS ONLY", this.consumerRecordTable, "TOPIC", "PARTITION", "RECORD_OFFSET", maxRecords);
            PreparedStatement statement = DatabaseUtils.createPreparedStatement(this.dataSource, sql);
            try {
                statement.setString(1, topic);
                statement.setInt(2, partition);
                list = DatabaseUtils.fetchConsumerRecords(statement.executeQuery());
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            statement.close();
        }
        return list;
    }

    @Override
    public void incrementRetries(long id) {
        String sql = String.format("UPDATE %s SET %s = %s + 1, %s = CURRENT_TIMESTAMP WHERE %s = ?", this.consumerRecordTable, "RETRIES", "RETRIES", "LAST_RETRY", "ID");
        try (PreparedStatement statement = DatabaseUtils.createPreparedStatement(this.dataSource, sql);){
            statement.setLong(1, id);
            statement.execute();
        }
    }

    @Override
    public List<TopicPartition> getTopicPartitions(List<String> topics) {
        List<TopicPartition> list;
        block8: {
            String sql = String.format("SELECT DISTINCT %s, %s FROM %s WHERE %s = ANY(?)", "TOPIC", "PARTITION", this.consumerRecordTable, "TOPIC");
            PreparedStatement statement = DatabaseUtils.createPreparedStatement(this.dataSource, sql);
            try {
                Array array = this.dataSource.getConnection().createArrayOf("VARCHAR", topics.toArray());
                statement.setArray(1, array);
                list = DatabaseUtils.fetchTopicPartitions(statement.executeQuery());
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            statement.close();
        }
        return list;
    }
}

