/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.util;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import no.nav.common.kafka.consumer.ConsumeStatus;
import no.nav.common.kafka.consumer.TopicConsumer;
import no.nav.common.kafka.consumer.util.ConsumerUtils;
import no.nav.common.kafka.consumer.util.TopicConsumerListener;
import no.nav.common.kafka.consumer.util.TopicConsumerLogger;
import no.nav.common.kafka.consumer.util.TopicConsumerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicConsumerBuilder<K, V> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<TopicConsumerListener<K, V>> listeners = new ArrayList<TopicConsumerListener<K, V>>();
    private TopicConsumer<K, V> consumer;

    private TopicConsumerBuilder() {
    }

    public static <K, V> TopicConsumerBuilder<K, V> builder() {
        return new TopicConsumerBuilder<K, V>();
    }

    public TopicConsumerBuilder<K, V> withConsumer(TopicConsumer<K, V> consumer) {
        this.consumer = consumer;
        return this;
    }

    public TopicConsumerBuilder<K, V> withLogging() {
        this.listeners.add(new TopicConsumerLogger());
        return this;
    }

    public TopicConsumerBuilder<K, V> withMetrics(MeterRegistry meterRegistry) {
        this.listeners.add(new TopicConsumerMetrics(meterRegistry));
        return this;
    }

    public TopicConsumerBuilder<K, V> withListener(TopicConsumerListener<K, V> consumerListener) {
        this.listeners.add(consumerListener);
        return this;
    }

    public TopicConsumer<K, V> build() {
        if (this.consumer == null) {
            throw new IllegalStateException("Cannot build TopicConsumer without consumer");
        }
        TopicConsumer topicConsumer = record -> {
            ConsumeStatus status = ConsumerUtils.safeConsume(this.consumer, record);
            this.listeners.forEach(listener -> {
                try {
                    listener.onConsumed(record, status);
                }
                catch (Exception e) {
                    this.log.error("Caught exception from consumer listener", (Throwable)e);
                }
            });
            return status;
        };
        return topicConsumer;
    }
}

