/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.producer.feilhandtering;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.util.List;
import javax.sql.DataSource;
import no.nav.common.kafka.producer.feilhandtering.KafkaProducerRepository;
import no.nav.common.kafka.producer.feilhandtering.StoredProducerRecord;
import no.nav.common.kafka.util.DatabaseUtils;

public class PostgresProducerRepository
implements KafkaProducerRepository {
    private final DataSource dataSource;
    private final String producerRecordTable;

    public PostgresProducerRepository(DataSource dataSource, String producerRecordTableName) {
        this.dataSource = dataSource;
        this.producerRecordTable = producerRecordTableName;
    }

    public PostgresProducerRepository(DataSource dataSource) {
        this(dataSource, "KAFKA_PRODUCER_RECORD");
    }

    @Override
    public long storeRecord(StoredProducerRecord record) {
        String sql = String.format("INSERT INTO %s (%s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, ?)", this.producerRecordTable, "ID", "TOPIC", "KEY", "VALUE", "HEADERS_JSON");
        long id = DatabaseUtils.incrementAndGetPostgresSequence(this.dataSource, "KAFKA_PRODUCER_RECORD_ID_SEQ");
        try (PreparedStatement statement = DatabaseUtils.createPreparedStatement(this.dataSource, sql);){
            statement.setLong(1, id);
            statement.setString(2, record.getTopic());
            statement.setBytes(3, record.getKey());
            statement.setBytes(4, record.getValue());
            statement.setString(5, record.getHeadersJson());
            statement.executeUpdate();
        }
        return id;
    }

    @Override
    public void deleteRecords(List<Long> ids) {
        String sql = String.format("DELETE FROM %s WHERE %s = ANY(?)", this.producerRecordTable, "ID");
        try (PreparedStatement statement = DatabaseUtils.createPreparedStatement(this.dataSource, sql);){
            Array array = this.dataSource.getConnection().createArrayOf("INTEGER", ids.toArray());
            statement.setArray(1, array);
            statement.executeUpdate();
        }
    }

    @Override
    public List<StoredProducerRecord> getRecords(int maxMessages) {
        List<StoredProducerRecord> list;
        block8: {
            String sql = String.format("SELECT * FROM %s ORDER BY %s LIMIT %d", this.producerRecordTable, "ID", maxMessages);
            PreparedStatement statement = DatabaseUtils.createPreparedStatement(this.dataSource, sql);
            try {
                list = DatabaseUtils.fetchProducerRecords(statement.executeQuery());
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            statement.close();
        }
        return list;
    }
}

