/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.util;

import java.util.Map;
import java.util.Properties;
import no.nav.common.utils.Credentials;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaPropertiesBuilder {
    public static final int DEFAULT_MAX_POLL_RECORDS = 500;
    public static final long DEFAULT_LINGER_MS = 500L;

    public static ConsumerPropertiesBuilder consumerBuilder() {
        return new ConsumerPropertiesBuilder();
    }

    public static ProducerPropertiesBuilder producerBuilder() {
        return new ProducerPropertiesBuilder();
    }

    public static class ConsumerPropertiesBuilder
    extends BasePropertiesBuilder<ConsumerPropertiesBuilder> {
        public ConsumerPropertiesBuilder withConsumerGroupId(String consumerGroupId) {
            this.properties.put("group.id", consumerGroupId);
            return this;
        }

        public ConsumerPropertiesBuilder withBaseProperties() {
            return this.withBaseProperties(500);
        }

        public ConsumerPropertiesBuilder withBaseProperties(int maxRecordsPrBatch) {
            this.properties.put("auto.offset.reset", "earliest");
            this.properties.put("enable.auto.commit", (Object)false);
            return this.withPollProperties(maxRecordsPrBatch, 1500 * maxRecordsPrBatch);
        }

        public ConsumerPropertiesBuilder withPollProperties(int maxRecordsPrBatch, int maxWaitForEachBatch) {
            this.properties.put("max.poll.records", (Object)maxRecordsPrBatch);
            this.properties.put("max.poll.interval.ms", (Object)maxWaitForEachBatch);
            return this;
        }

        public <K extends Deserializer<?>, V extends Deserializer<?>> ConsumerPropertiesBuilder withDeserializers(Class<K> keyDeserializerClass, Class<V> valueDeserializerClass) {
            this.properties.put("key.deserializer", keyDeserializerClass);
            this.properties.put("value.deserializer", valueDeserializerClass);
            return this;
        }

        @Override
        public Properties build() {
            Object keyDeserializer = this.properties.get("key.deserializer");
            Object valueDeserializer = this.properties.get("value.deserializer");
            if (keyDeserializer == null) {
                throw new IllegalStateException("Key deserializer is missing");
            }
            if (valueDeserializer == null) {
                throw new IllegalStateException("Value deserializer is missing");
            }
            return super.build();
        }
    }

    public static class ProducerPropertiesBuilder
    extends BasePropertiesBuilder<ProducerPropertiesBuilder> {
        public ProducerPropertiesBuilder withProducerId(String producerId) {
            this.properties.put("client.id", producerId);
            return this;
        }

        public ProducerPropertiesBuilder withBaseProperties() {
            this.properties.put("acks", "all");
            this.properties.put("linger.ms", (Object)500L);
            return this;
        }

        public <K extends Serializer<?>, V extends Serializer<?>> ProducerPropertiesBuilder withSerializers(Class<K> keySerializerClass, Class<V> valueSerializerClass) {
            this.properties.put("key.serializer", keySerializerClass);
            this.properties.put("value.serializer", valueSerializerClass);
            return this;
        }

        @Override
        public Properties build() {
            Object keySerializer = this.properties.get("key.serializer");
            Object valueSerializer = this.properties.get("value.serializer");
            if (keySerializer == null) {
                throw new IllegalStateException("Key serializer is missing");
            }
            if (valueSerializer == null) {
                throw new IllegalStateException("Value serializer is missing");
            }
            return super.build();
        }
    }

    public static abstract class BasePropertiesBuilder<T extends BasePropertiesBuilder<?>> {
        final Properties properties = new Properties();

        public T withBrokerUrl(String brokerUrl) {
            this.properties.put("bootstrap.servers", brokerUrl);
            return (T)this;
        }

        public T withOnPremAuth(String username, String password) {
            return this.withOnPremAuth(new Credentials(username, password));
        }

        public T withOnPremAuth(Credentials credentials) {
            this.properties.put("security.protocol", "SASL_SSL");
            this.properties.put("sasl.mechanism", "PLAIN");
            this.properties.put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + credentials.username + "\" password=\"" + credentials.password + "\";");
            return (T)this;
        }

        public T withProp(String key, Object value) {
            this.properties.put(key, value);
            return (T)this;
        }

        public T withProps(Properties properties) {
            this.properties.putAll((Map<?, ?>)properties);
            return (T)this;
        }

        public Properties build() {
            if (!this.properties.containsKey("bootstrap.servers")) {
                throw new IllegalStateException("bootstrap.servers is missing");
            }
            return this.properties;
        }
    }
}

