/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.util;

import java.util.function.BiFunction;
import no.nav.common.json.JsonUtils;
import no.nav.common.kafka.consumer.ConsumeStatus;
import no.nav.common.kafka.consumer.TopicConsumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class JsonTopicConsumer<K, V, T>
implements TopicConsumer<K, V> {
    private final BiFunction<ConsumerRecord<K, V>, T, ConsumeStatus> consumer;
    private final Class<T> dataClass;

    public JsonTopicConsumer(Class<T> dataClass, BiFunction<ConsumerRecord<K, V>, T, ConsumeStatus> consumer) {
        this.dataClass = dataClass;
        this.consumer = consumer;
    }

    @Override
    public ConsumeStatus consume(ConsumerRecord<K, V> record) {
        String stringValue = JsonTopicConsumer.assertedString(record.value());
        return this.consumer.apply(record, (ConsumerRecord<K, V>)JsonUtils.fromJson((String)stringValue, this.dataClass));
    }

    private static String assertedString(Object obj) {
        if (!(obj instanceof String)) {
            throw new IllegalStateException("JsonTopicConsumer can only consume topics where the value is a String");
        }
        return (String)obj;
    }
}

