/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.producer.util;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Properties;
import no.nav.common.kafka.producer.KafkaProducerClient;
import no.nav.common.kafka.producer.KafkaProducerClientImpl;
import no.nav.common.kafka.producer.util.KafkaProducerClientWithMetrics;

public class KafkaProducerClientBuilder<K, V> {
    private Properties properties;
    private MeterRegistry meterRegistry;

    private KafkaProducerClientBuilder() {
    }

    public static <K, V> KafkaProducerClientBuilder<K, V> builder() {
        return new KafkaProducerClientBuilder<K, V>();
    }

    public KafkaProducerClientBuilder<K, V> withProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public KafkaProducerClientBuilder<K, V> withMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    public KafkaProducerClient<K, V> build() {
        if (this.properties == null) {
            throw new IllegalStateException("Cannot build kafka producer without properties");
        }
        KafkaProducerClient producerClient = new KafkaProducerClientImpl(this.properties);
        if (this.meterRegistry != null) {
            producerClient = new KafkaProducerClientWithMetrics(producerClient, this.meterRegistry);
        }
        return producerClient;
    }
}

