/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import no.nav.common.kafka.consumer.feilhandtering.StoredConsumerRecord;
import no.nav.common.kafka.producer.feilhandtering.StoredProducerRecord;
import org.apache.kafka.common.TopicPartition;

public class DatabaseUtils {
    public static List<StoredProducerRecord> fetchProducerRecords(ResultSet resultSet) {
        ArrayList<StoredProducerRecord> arrayList;
        block9: {
            ResultSet resultSet2 = resultSet;
            try {
                ArrayList<StoredProducerRecord> records = new ArrayList<StoredProducerRecord>();
                while (resultSet.next()) {
                    long id = resultSet.getInt("ID");
                    String topic = resultSet.getString("TOPIC");
                    String headersJson = resultSet.getString("HEADERS_JSON");
                    byte[] key = resultSet.getBytes("KEY");
                    byte[] value = resultSet.getBytes("VALUE");
                    records.add(new StoredProducerRecord(id, topic, key, value, headersJson));
                }
                arrayList = records;
                if (resultSet2 == null) break block9;
            }
            catch (Throwable throwable) {
                if (resultSet2 != null) {
                    try {
                        resultSet2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            resultSet2.close();
        }
        return arrayList;
    }

    public static List<StoredConsumerRecord> fetchConsumerRecords(ResultSet resultSet) {
        ArrayList<StoredConsumerRecord> arrayList;
        block9: {
            ResultSet resultSet2 = resultSet;
            try {
                ArrayList<StoredConsumerRecord> records = new ArrayList<StoredConsumerRecord>();
                while (resultSet.next()) {
                    long id = resultSet.getInt("ID");
                    String topic = resultSet.getString("TOPIC");
                    int partition = resultSet.getInt("PARTITION");
                    long offset = resultSet.getLong("RECORD_OFFSET");
                    byte[] key = resultSet.getBytes("KEY");
                    byte[] value = resultSet.getBytes("VALUE");
                    String headersJson = resultSet.getString("HEADERS_JSON");
                    int retries = resultSet.getInt("RETRIES");
                    Timestamp lastRetry = resultSet.getTimestamp("LAST_RETRY");
                    long timestamp = resultSet.getLong("RECORD_TIMESTAMP");
                    records.add(new StoredConsumerRecord(id, topic, partition, offset, key, value, headersJson, retries, lastRetry, timestamp));
                }
                arrayList = records;
                if (resultSet2 == null) break block9;
            }
            catch (Throwable throwable) {
                if (resultSet2 != null) {
                    try {
                        resultSet2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            resultSet2.close();
        }
        return arrayList;
    }

    public static List<TopicPartition> fetchTopicPartitions(ResultSet resultSet) {
        ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
        while (resultSet.next()) {
            String topic = resultSet.getString("TOPIC");
            int partition = resultSet.getInt("PARTITION");
            topicPartitions.add(new TopicPartition(topic, partition));
        }
        return topicPartitions;
    }

    public static long incrementAndGetPostgresSequence(Connection connection, String sequenceName) {
        long l;
        block8: {
            String sql = String.format("SELECT nextval('%s')", sequenceName);
            Statement statement = connection.createStatement();
            try {
                l = DatabaseUtils.fetchSequence(statement.executeQuery(sql));
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            statement.close();
        }
        return l;
    }

    public static long incrementAndGetOracleSequence(Connection connection, String sequenceName) {
        long l;
        block8: {
            String sql = String.format("SELECT %s.NEXTVAL FROM dual", sequenceName);
            Statement statement = connection.createStatement();
            try {
                l = DatabaseUtils.fetchSequence(statement.executeQuery(sql));
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            statement.close();
        }
        return l;
    }

    public static long fetchSequence(ResultSet resultSet) {
        long l;
        block9: {
            ResultSet resultSet2 = resultSet;
            try {
                if (!resultSet.next()) {
                    throw new IllegalStateException("Result set does not contain sequence");
                }
                l = resultSet.getLong(1);
                if (resultSet2 == null) break block9;
            }
            catch (Throwable throwable) {
                if (resultSet2 != null) {
                    try {
                        resultSet2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            resultSet2.close();
        }
        return l;
    }
}

