/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.feilhandtering;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.List;
import javax.sql.DataSource;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRepository;
import no.nav.common.kafka.consumer.feilhandtering.StoredConsumerRecord;
import no.nav.common.kafka.util.DatabaseUtils;
import org.apache.kafka.common.TopicPartition;

public class OracleConsumerRepository
implements KafkaConsumerRepository {
    private final DataSource dataSource;
    private final String consumerRecordTable;

    public OracleConsumerRepository(DataSource dataSource, String consumerRecordTable) {
        this.dataSource = dataSource;
        this.consumerRecordTable = consumerRecordTable;
    }

    public OracleConsumerRepository(DataSource dataSource) {
        this(dataSource, "KAFKA_CONSUMER_RECORD");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public long storeRecord(StoredConsumerRecord record) {
        String sql = String.format("INSERT INTO %s (%s, %s, %s, %s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", this.consumerRecordTable, "ID", "TOPIC", "PARTITION", "RECORD_OFFSET", "KEY", "VALUE", "HEADERS_JSON", "RECORD_TIMESTAMP");
        try (Connection connection = this.dataSource.getConnection();){
            long l;
            block16: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    long id = DatabaseUtils.incrementAndGetOracleSequence(connection, "KAFKA_CONSUMER_RECORD_ID_SEQ");
                    statement.setLong(1, id);
                    statement.setString(2, record.getTopic());
                    statement.setInt(3, record.getPartition());
                    statement.setLong(4, record.getOffset());
                    statement.setBytes(5, record.getKey());
                    statement.setBytes(6, record.getValue());
                    statement.setString(7, record.getHeadersJson());
                    statement.setLong(8, record.getTimestamp());
                    statement.executeUpdate();
                    l = id;
                    if (statement == null) break block16;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return l;
        }
        catch (SQLIntegrityConstraintViolationException e) {
            return -1L;
        }
    }

    @Override
    public void deleteRecords(List<Long> ids) {
        String sql = String.format("DELETE FROM %s WHERE %s = ANY(?)", this.consumerRecordTable, "ID");
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            Array array = connection.createArrayOf("INTEGER", ids.toArray());
            statement.setArray(1, array);
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasRecordWithKey(String topic, int partition, byte[] key) {
        String sql = String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ? AND %s = ? FETCH NEXT 1 ROWS ONLY", "ID", this.consumerRecordTable, "TOPIC", "PARTITION", "KEY");
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setString(1, topic);
                    statement.setInt(2, partition);
                    statement.setBytes(3, key);
                    bl = statement.executeQuery().next();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<StoredConsumerRecord> getRecords(String topic, int partition, int maxRecords) {
        String sql = String.format("SELECT * FROM %s WHERE %s = ? AND %s = ? ORDER BY %s FETCH NEXT %d ROWS ONLY", this.consumerRecordTable, "TOPIC", "PARTITION", "RECORD_OFFSET", maxRecords);
        try (Connection connection = this.dataSource.getConnection();){
            List<StoredConsumerRecord> list;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setString(1, topic);
                    statement.setInt(2, partition);
                    list = DatabaseUtils.fetchConsumerRecords(statement.executeQuery());
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
    }

    @Override
    public void incrementRetries(long id) {
        String sql = String.format("UPDATE %s SET %s = %s + 1, %s = CURRENT_TIMESTAMP WHERE %s = ?", this.consumerRecordTable, "RETRIES", "RETRIES", "LAST_RETRY", "ID");
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, id);
            statement.execute();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<TopicPartition> getTopicPartitions(List<String> topics) {
        String sql = String.format("SELECT DISTINCT %s, %s FROM %s WHERE %s = ANY(?)", "TOPIC", "PARTITION", this.consumerRecordTable, "TOPIC");
        try (Connection connection = this.dataSource.getConnection();){
            List<TopicPartition> list;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    Array array = connection.createArrayOf("VARCHAR", topics.toArray());
                    statement.setArray(1, array);
                    list = DatabaseUtils.fetchTopicPartitions(statement.executeQuery());
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
    }
}

