/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.producer.feilhandtering;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import javax.sql.DataSource;
import no.nav.common.kafka.producer.feilhandtering.KafkaProducerRepository;
import no.nav.common.kafka.producer.feilhandtering.StoredProducerRecord;
import no.nav.common.kafka.util.DatabaseUtils;

public class OracleProducerRepository
implements KafkaProducerRepository {
    private final DataSource dataSource;
    private final String producerRecordTable;

    public OracleProducerRepository(DataSource dataSource, String producerRecordTableName) {
        this.dataSource = dataSource;
        this.producerRecordTable = producerRecordTableName;
    }

    public OracleProducerRepository(DataSource dataSource) {
        this(dataSource, "KAFKA_PRODUCER_RECORD");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public long storeRecord(StoredProducerRecord record) {
        String sql = String.format("INSERT INTO %s (%s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, ?)", this.producerRecordTable, "ID", "TOPIC", "KEY", "VALUE", "HEADERS_JSON");
        try (Connection connection = this.dataSource.getConnection();){
            long l;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    long id = DatabaseUtils.incrementAndGetOracleSequence(connection, "KAFKA_PRODUCER_RECORD_ID_SEQ");
                    statement.setLong(1, id);
                    statement.setString(2, record.getTopic());
                    statement.setBytes(3, record.getKey());
                    statement.setBytes(4, record.getValue());
                    statement.setString(5, record.getHeadersJson());
                    statement.executeUpdate();
                    l = id;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return l;
        }
    }

    @Override
    public void deleteRecords(List<Long> ids) {
        String sql = String.format("DELETE FROM %s WHERE %s = ANY(?)", this.producerRecordTable, "ID");
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            Array array = connection.createArrayOf("INTEGER", ids.toArray());
            statement.setArray(1, array);
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<StoredProducerRecord> getRecords(int maxMessages) {
        String sql = String.format("SELECT * FROM %s ORDER BY %s FETCH NEXT %d ROWS ONLY", this.producerRecordTable, "ID", maxMessages);
        try (Connection connection = this.dataSource.getConnection();){
            List<StoredProducerRecord> list;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    list = DatabaseUtils.fetchProducerRecords(statement.executeQuery());
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
    }
}

