/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.feilhandtering;

import no.nav.common.kafka.consumer.ConsumeStatus;
import no.nav.common.kafka.consumer.TopicConsumer;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRepository;
import no.nav.common.kafka.consumer.util.ConsumerUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.Serializer;

public class StoreOnFailureTopicConsumer<K, V>
implements TopicConsumer<K, V> {
    private final TopicConsumer<K, V> consumer;
    private final KafkaConsumerRepository consumerRepository;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;

    public StoreOnFailureTopicConsumer(TopicConsumer<K, V> consumer, KafkaConsumerRepository consumerRepository, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.consumer = consumer;
        this.consumerRepository = consumerRepository;
    }

    @Override
    public ConsumeStatus consume(ConsumerRecord<K, V> record) {
        ConsumeStatus status;
        boolean shouldConsumeRecord;
        byte[] key = this.keySerializer.serialize(record.topic(), record.key());
        boolean bl = shouldConsumeRecord = record.key() == null || !this.consumerRepository.hasRecordWithKey(record.topic(), record.partition(), key);
        if (shouldConsumeRecord && (status = ConsumerUtils.safeConsume(this.consumer, record)) == ConsumeStatus.OK) {
            return ConsumeStatus.OK;
        }
        this.consumerRepository.storeRecord(ConsumerUtils.mapToStoredRecord(record, this.keySerializer, this.valueSerializer));
        return ConsumeStatus.OK;
    }
}

