/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.util;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.NonNull;
import no.nav.common.kafka.consumer.KafkaConsumerClient;
import no.nav.common.kafka.consumer.KafkaConsumerClientConfig;
import no.nav.common.kafka.consumer.TopicConsumer;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRepository;
import no.nav.common.kafka.consumer.feilhandtering.StoreOnFailureTopicConsumer;
import no.nav.common.kafka.consumer.util.TopicConsumerBuilder;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaConsumerClientBuilder<K, V> {
    private final Map<String, TopicConsumer<K, V>> consumerMap = new HashMap<String, TopicConsumer<K, V>>();
    private final Map<String, TopicConsumer<K, V>> consumersWithErrorHandlingMap = new HashMap<String, TopicConsumer<K, V>>();
    private Properties properties;
    private Properties additionalProperties;
    private long pollDurationMs = -1L;
    private KafkaConsumerRepository consumerRepository;
    private Serializer<K> keySerializer;
    private Serializer<V> valueSerializer;
    private boolean enableLogging;
    private MeterRegistry meterRegistry;

    private KafkaConsumerClientBuilder() {
    }

    public static <K, V> KafkaConsumerClientBuilder<K, V> builder() {
        return new KafkaConsumerClientBuilder<K, V>();
    }

    public KafkaConsumerClientBuilder<K, V> withProperties(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties = (Properties)properties.clone();
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withAdditionalProperties(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.additionalProperties = (Properties)properties.clone();
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withAdditionalProperty(@NonNull String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (this.additionalProperties == null) {
            this.additionalProperties = new Properties();
        }
        this.additionalProperties.put(name, value);
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withConsumer(@NonNull String topic, @NonNull TopicConsumer<K, V> consumer) {
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        this.consumerMap.put(topic, consumer);
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withConsumers(@NonNull Map<String, TopicConsumer<K, V>> topicConsumers) {
        if (topicConsumers == null) {
            throw new NullPointerException("topicConsumers is marked non-null but is null");
        }
        this.consumerMap.putAll(topicConsumers);
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withStoreOnFailureConsumer(@NonNull String topic, @NonNull TopicConsumer<K, V> topicConsumer) {
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        if (topicConsumer == null) {
            throw new NullPointerException("topicConsumer is marked non-null but is null");
        }
        this.consumersWithErrorHandlingMap.put(topic, topicConsumer);
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withStoreOnFailureConsumers(@NonNull Map<String, TopicConsumer<K, V>> topicConsumers) {
        if (topicConsumers == null) {
            throw new NullPointerException("topicConsumers is marked non-null but is null");
        }
        this.consumersWithErrorHandlingMap.putAll(topicConsumers);
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withLogging() {
        this.enableLogging = true;
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withRepository(KafkaConsumerRepository consumerRepository) {
        this.consumerRepository = consumerRepository;
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withSerializers(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        return this;
    }

    public KafkaConsumerClientBuilder<K, V> withPollDuration(long pollDurationMs) {
        this.pollDurationMs = pollDurationMs;
        return this;
    }

    public KafkaConsumerClient<K, V> build() {
        if (this.properties == null) {
            throw new IllegalStateException("Cannot build kafka consumer without properties");
        }
        if (!this.consumersWithErrorHandlingMap.isEmpty()) {
            if (this.consumerRepository == null) {
                throw new IllegalStateException("Consumer repository is required when using error handling");
            }
            if (this.keySerializer == null || this.valueSerializer == null) {
                throw new IllegalStateException("Key serializer and value serializer is required when using error handling");
            }
        }
        this.consumersWithErrorHandlingMap.forEach((topic, consumer) -> this.consumerMap.put((String)topic, (TopicConsumer<String, StoreOnFailureTopicConsumer<K, V>>)new StoreOnFailureTopicConsumer<K, V>(consumer, this.consumerRepository, this.keySerializer, this.valueSerializer)));
        HashMap extendedConsumers = new HashMap();
        this.consumerMap.forEach((topic, consumer) -> {
            TopicConsumerBuilder builder = TopicConsumerBuilder.builder();
            if (this.enableLogging) {
                builder.withLogging();
            }
            if (this.meterRegistry != null) {
                builder.withMetrics(this.meterRegistry);
            }
            builder.withConsumer(consumer);
            extendedConsumers.put((String)topic, builder.build());
        });
        KafkaConsumerClientConfig config = new KafkaConsumerClientConfig(this.properties, extendedConsumers);
        if (this.pollDurationMs >= 0L) {
            config.setPollDurationMs(this.pollDurationMs);
        }
        return new KafkaConsumerClient(config);
    }
}

