/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import no.nav.common.json.JsonUtils;
import no.nav.common.utils.StringUtils;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class KafkaUtils {
    public static String headersToJson(Headers headers) {
        if (headers == null) {
            return "[]";
        }
        List kafkaHeaders = Arrays.stream(headers.toArray()).map(header -> new KafkaHeader(header.key(), header.value())).collect(Collectors.toList());
        return JsonUtils.toJson(kafkaHeaders);
    }

    public static Headers jsonToHeaders(String headersJson) {
        if (StringUtils.nullOrEmpty((String)headersJson)) {
            return new RecordHeaders();
        }
        List headers = JsonUtils.fromJsonArray((String)headersJson, KafkaHeader.class).stream().map(header -> new RecordHeader(header.getKey(), header.getValue())).collect(Collectors.toList());
        return new RecordHeaders(headers);
    }

    static class KafkaHeader {
        String key;
        byte[] value;

        public KafkaHeader(String key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KafkaHeader)) {
                return false;
            }
            KafkaHeader other = (KafkaHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof KafkaHeader;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "KafkaUtils.KafkaHeader(key=" + this.getKey() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }
    }
}

