/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.producer.util;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.Properties;
import lombok.NonNull;
import no.nav.common.kafka.producer.KafkaProducerClient;
import no.nav.common.kafka.producer.KafkaProducerClientImpl;
import no.nav.common.kafka.producer.util.KafkaProducerClientWithMetrics;

public class KafkaProducerClientBuilder<K, V> {
    private Properties properties;
    private Properties additionalProperties;
    private MeterRegistry meterRegistry;

    private KafkaProducerClientBuilder() {
    }

    public static <K, V> KafkaProducerClientBuilder<K, V> builder() {
        return new KafkaProducerClientBuilder<K, V>();
    }

    public KafkaProducerClientBuilder<K, V> withProperties(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties = (Properties)properties.clone();
        return this;
    }

    public KafkaProducerClientBuilder<K, V> withAdditionalProperties(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.additionalProperties = (Properties)properties.clone();
        return this;
    }

    public KafkaProducerClientBuilder<K, V> withAdditionalProperty(@NonNull String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (this.additionalProperties == null) {
            this.additionalProperties = new Properties();
        }
        this.additionalProperties.put(name, value);
        return this;
    }

    public KafkaProducerClientBuilder<K, V> withMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    public KafkaProducerClient<K, V> build() {
        if (this.properties == null) {
            throw new IllegalStateException("Cannot build kafka producer without properties");
        }
        if (this.additionalProperties != null) {
            this.properties.putAll((Map<?, ?>)this.additionalProperties);
        }
        KafkaProducerClient producerClient = new KafkaProducerClientImpl(this.properties);
        if (this.meterRegistry != null) {
            producerClient = new KafkaProducerClientWithMetrics(producerClient, this.meterRegistry);
        }
        return producerClient;
    }
}

