/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer;

import java.util.List;
import no.nav.common.kafka.consumer.KafkaConsumerClient;
import no.nav.common.kafka.consumer.KafkaConsumerClientConfig;
import no.nav.common.kafka.consumer.KafkaConsumerClientImpl;
import no.nav.common.kafka.consumer.util.ConsumerClientExceptionListener;
import org.apache.kafka.common.errors.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingCredentialsKafkaConsumerClient
implements KafkaConsumerClient,
ConsumerClientExceptionListener {
    private static final Logger log = LoggerFactory.getLogger(RollingCredentialsKafkaConsumerClient.class);
    private final KafkaConsumerClientConfig<?, ?> consumerClientConfig;
    private volatile KafkaConsumerClient kafkaConsumerClient;

    public RollingCredentialsKafkaConsumerClient(KafkaConsumerClientConfig<?, ?> consumerClientConfig) {
        this.consumerClientConfig = consumerClientConfig;
        consumerClientConfig.setExceptionListeners(List.of(this));
        this.kafkaConsumerClient = new KafkaConsumerClientImpl(consumerClientConfig);
    }

    @Override
    public void start() {
        this.kafkaConsumerClient.start();
    }

    @Override
    public void stop() {
        this.kafkaConsumerClient.stop();
    }

    @Override
    public boolean isRunning() {
        return this.kafkaConsumerClient.isRunning();
    }

    @Override
    public void onExceptionCaught(Exception e) {
        if (e instanceof AuthenticationException) {
            log.info("Received AuthenticationException when consuming from topic. Recreating consumer client");
            this.kafkaConsumerClient.stop();
            this.kafkaConsumerClient = new KafkaConsumerClientImpl(this.consumerClientConfig);
            this.kafkaConsumerClient.start();
        }
    }
}

