/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.util.deserializer;

import java.util.List;
import java.util.UUID;
import no.nav.common.kafka.consumer.util.deserializer.AvroDeserializer;
import no.nav.common.kafka.consumer.util.deserializer.JsonArrayDeserializer;
import no.nav.common.kafka.consumer.util.deserializer.JsonObjectDeserializer;
import no.nav.common.utils.EnvironmentUtils;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.FloatDeserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.ShortDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.UUIDDeserializer;

public class Deserializers {
    public static Deserializer<String> stringDeserializer() {
        return new StringDeserializer();
    }

    public static Deserializer<Long> longDeserializer() {
        return new LongDeserializer();
    }

    public static Deserializer<Short> shortDeserializer() {
        return new ShortDeserializer();
    }

    public static Deserializer<Double> doubleDeserializer() {
        return new DoubleDeserializer();
    }

    public static Deserializer<Float> floatDeserializer() {
        return new FloatDeserializer();
    }

    public static Deserializer<Integer> integerDeserializer() {
        return new IntegerDeserializer();
    }

    public static Deserializer<UUID> uuidDeserializer() {
        return new UUIDDeserializer();
    }

    public static <T> Deserializer<T> jsonDeserializer(Class<T> jsonClass) {
        return new JsonObjectDeserializer<T>(jsonClass);
    }

    public static <T> Deserializer<List<T>> jsonArrayDeserializer(Class<T> jsonClass) {
        return new JsonArrayDeserializer<T>(jsonClass);
    }

    public static <T> Deserializer<T> onPremAvroDeserializer(String schemaRegistryUrl) {
        return new AvroDeserializer(schemaRegistryUrl);
    }

    public static <T> Deserializer<T> aivenAvroDeserializer() {
        String schemaRegistryUrl = EnvironmentUtils.getRequiredProperty((String)"KAFKA_SCHEMA_REGISTRY", (String[])new String[0]);
        String username = EnvironmentUtils.getRequiredProperty((String)"KAFKA_SCHEMA_REGISTRY_USER", (String[])new String[0]);
        String password = EnvironmentUtils.getRequiredProperty((String)"KAFKA_SCHEMA_REGISTRY_PASSWORD", (String[])new String[0]);
        return new AvroDeserializer(schemaRegistryUrl, username, password);
    }
}

