/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.producer;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import no.nav.common.kafka.producer.KafkaProducerClient;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingCredentialsKafkaProducerClient<K, V>
implements KafkaProducerClient<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RollingCredentialsKafkaProducerClient.class);
    private final Supplier<KafkaProducerClient<K, V>> producerClientSupplier;
    private volatile KafkaProducerClient<K, V> kafkaProducerClient;

    public RollingCredentialsKafkaProducerClient(Supplier<KafkaProducerClient<K, V>> producerClientSupplier) {
        this.producerClientSupplier = producerClientSupplier;
        this.kafkaProducerClient = producerClientSupplier.get();
    }

    @Override
    public void close() {
        this.kafkaProducerClient.close();
    }

    @Override
    public RecordMetadata sendSync(ProducerRecord<K, V> record) {
        try {
            return this.send(record, null).get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        Callback errorHandlerCallback = (metadata, exception) -> {
            try {
                if (exception instanceof AuthenticationException) {
                    log.info("Received AuthenticationException when sending record. Recreating producer client");
                    this.kafkaProducerClient = this.producerClientSupplier.get();
                    this.kafkaProducerClient.send(record, callback);
                } else if (callback != null) {
                    callback.onCompletion(metadata, exception);
                }
            }
            catch (Exception e) {
                log.error("Unexpected exception caught when recreating client due to AuthenticationException", (Throwable)e);
            }
        };
        return this.kafkaProducerClient.send(record, errorHandlerCallback);
    }

    @Override
    public Producer<K, V> getProducer() {
        return this.kafkaProducerClient.getProducer();
    }
}

