/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.producer.util;

import no.nav.common.json.JsonUtils;
import no.nav.common.kafka.producer.feilhandtering.StoredProducerRecord;
import no.nav.common.kafka.producer.serializer.JsonSerializer;
import no.nav.common.kafka.util.KafkaUtils;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class ProducerUtils {
    public static final Serializer<byte[]> BYTE_ARRAY_SERIALIZER = new ByteArraySerializer();
    public static final Serializer<String> STRING_SERIALIZER = new StringSerializer();
    public static final Serializer<Object> JSON_SERIALIZER = new JsonSerializer<Object>();

    private ProducerUtils() {
    }

    public static ProducerRecord<String, String> toJsonProducerRecord(String topic, Object value) {
        return new ProducerRecord(topic, (Object)JsonUtils.toJson((Object)value));
    }

    public static ProducerRecord<String, String> toJsonProducerRecord(String topic, String key, Object value) {
        return new ProducerRecord(topic, (Object)key, (Object)JsonUtils.toJson((Object)value));
    }

    public static ProducerRecord<String, String> toProducerRecord(String topic, String key, String value) {
        return new ProducerRecord(topic, (Object)key, (Object)value);
    }

    public static ProducerRecord<byte[], byte[]> serializeStringRecord(ProducerRecord<String, String> record) {
        return ProducerUtils.serializeRecord(record, STRING_SERIALIZER, STRING_SERIALIZER);
    }

    public static ProducerRecord<byte[], byte[]> serializeJsonRecord(ProducerRecord<String, Object> record) {
        return ProducerUtils.serializeRecord(record, STRING_SERIALIZER, JSON_SERIALIZER);
    }

    public static <K, V> ProducerRecord<byte[], byte[]> serializeRecord(ProducerRecord<K, V> record, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        byte[] key = keySerializer.serialize(record.topic(), record.key());
        byte[] value = valueSerializer.serialize(record.topic(), record.value());
        return new ProducerRecord(record.topic(), record.partition(), (Object)key, (Object)value, (Iterable)record.headers());
    }

    public static StoredProducerRecord mapToStoredRecord(ProducerRecord<byte[], byte[]> record) {
        return ProducerUtils.mapToStoredRecord(record, BYTE_ARRAY_SERIALIZER, BYTE_ARRAY_SERIALIZER);
    }

    public static <K, V> StoredProducerRecord mapToStoredRecord(ProducerRecord<K, V> record, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        byte[] key = keySerializer.serialize(record.topic(), record.key());
        byte[] value = valueSerializer.serialize(record.topic(), record.value());
        String headersJson = KafkaUtils.headersToJson(record.headers());
        return new StoredProducerRecord(record.topic(), key, value, headersJson);
    }

    public static ProducerRecord<byte[], byte[]> mapFromStoredRecord(StoredProducerRecord record) {
        Headers headers = KafkaUtils.jsonToHeaders(record.getHeadersJson());
        return new ProducerRecord(record.getTopic(), null, null, (Object)record.getKey(), (Object)record.getValue(), (Iterable)headers);
    }
}

