/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.util.deserializer;

import java.nio.charset.StandardCharsets;
import java.util.List;
import no.nav.common.json.JsonUtils;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonArrayDeserializer<T>
implements Deserializer<List<T>> {
    private final Class<T> dataClass;

    public JsonArrayDeserializer(Class<T> dataClass) {
        this.dataClass = dataClass;
    }

    public List<T> deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        String dataStr = new String(data, StandardCharsets.UTF_8);
        return JsonUtils.fromJsonArray((String)dataStr, this.dataClass);
    }
}

